/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (false ? uvec2(38u, 35u) : uvec2(38u, 35u)) => uvec2(38u, 35u)
 * (false ? uvec2(38u, 35u) : uvec2(64u, 9u)) => uvec2(64u, 9u)
 * (false ? uvec2(64u, 9u) : uvec2(38u, 35u)) => uvec2(38u, 35u)
 * (false ? uvec2(64u, 9u) : uvec2(64u, 9u)) => uvec2(64u, 9u)
 * (true ? uvec2(38u, 35u) : uvec2(38u, 35u)) => uvec2(38u, 35u)
 * (true ? uvec2(38u, 35u) : uvec2(64u, 9u)) => uvec2(38u, 35u)
 * (true ? uvec2(64u, 9u) : uvec2(38u, 35u)) => uvec2(64u, 9u)
 * (true ? uvec2(64u, 9u) : uvec2(64u, 9u)) => uvec2(64u, 9u)
 */
#version 130

void main()
{
  float[all(equal((false ? uvec2(38u, 35u) : uvec2(38u, 35u)), uvec2(38u, 35u))) ? 1 : -1] array0;
  float[all(equal((false ? uvec2(38u, 35u) : uvec2(64u, 9u)), uvec2(64u, 9u))) ? 1 : -1] array1;
  float[all(equal((false ? uvec2(64u, 9u) : uvec2(38u, 35u)), uvec2(38u, 35u))) ? 1 : -1] array2;
  float[all(equal((false ? uvec2(64u, 9u) : uvec2(64u, 9u)), uvec2(64u, 9u))) ? 1 : -1] array3;
  float[all(equal((true ? uvec2(38u, 35u) : uvec2(38u, 35u)), uvec2(38u, 35u))) ? 1 : -1] array4;
  float[all(equal((true ? uvec2(38u, 35u) : uvec2(64u, 9u)), uvec2(38u, 35u))) ? 1 : -1] array5;
  float[all(equal((true ? uvec2(64u, 9u) : uvec2(38u, 35u)), uvec2(64u, 9u))) ? 1 : -1] array6;
  float[all(equal((true ? uvec2(64u, 9u) : uvec2(64u, 9u)), uvec2(64u, 9u))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
