/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKBinderParser
extends Parser<PSKBinder> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PSKBinderParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public PSKBinder parse() {
        LOGGER.debug("Parsing PSKBinder");
        PSKBinder pskBinder = new PSKBinder();
        this.parseBinderLength(pskBinder);
        this.parseBinderEntry(pskBinder);
        return pskBinder;
    }

    private void parseBinderLength(PSKBinder pskBinder) {
        pskBinder.setBinderEntryLength(this.parseIntField(1));
        LOGGER.debug("Binder length:" + pskBinder.getBinderEntryLength().getValue());
    }

    private void parseBinderEntry(PSKBinder pskBinder) {
        pskBinder.setBinderEntry(this.parseByteArrayField((Integer)pskBinder.getBinderEntryLength().getValue()));
        LOGGER.debug("Parsed binder:" + ArrayConverter.bytesToHexString((byte[])((byte[])pskBinder.getBinderEntry().getValue())));
    }
}

