/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.firebase.auth.UserImportHash;
import java.util.Map;

public final class Argon2
extends UserImportHash {
    private static final int MIN_HASH_LENGTH_BYTES = 4;
    private static final int MAX_HASH_LENGTH_BYTES = 1024;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = 16;
    private static final int MIN_ITERATIONS = 1;
    private static final int MAX_ITERATIONS = 16;
    private static final int MIN_MEMORY_COST_KIB = 1;
    private static final int MAX_MEMORY_COST_KIB = 32768;
    private final int hashLengthBytes;
    private final Argon2HashType hashType;
    private final int parallelism;
    private final int iterations;
    private final int memoryCostKib;
    private final Argon2Version version;
    private final String associatedData;

    private Argon2(Builder builder) {
        super("ARGON2");
        Preconditions.checkArgument((boolean)Argon2.intShouldBeBetweenLimitsInclusive(builder.hashLengthBytes, 4, 1024), (String)"hashLengthBytes is required for Argon2 and must be between %s and %s", (int)4, (int)1024);
        Preconditions.checkArgument((builder.hashType != null ? 1 : 0) != 0, (Object)"A hashType is required for Argon2");
        Preconditions.checkArgument((boolean)Argon2.intShouldBeBetweenLimitsInclusive(builder.parallelism, 1, 16), (String)"parallelism is required for Argon2 and must be between %s and %s", (int)1, (int)16);
        Preconditions.checkArgument((boolean)Argon2.intShouldBeBetweenLimitsInclusive(builder.iterations, 1, 16), (String)"iterations is required for Argon2 and must be between %s and %s", (int)1, (int)16);
        Preconditions.checkArgument((boolean)Argon2.intShouldBeBetweenLimitsInclusive(builder.memoryCostKib, 1, 32768), (String)"memoryCostKib is required for Argon2 and must be less than or equal to %s", (int)32768);
        this.hashLengthBytes = builder.hashLengthBytes;
        this.hashType = builder.hashType;
        this.parallelism = builder.parallelism;
        this.iterations = builder.iterations;
        this.memoryCostKib = builder.memoryCostKib;
        this.version = builder.version != null ? builder.version : null;
        this.associatedData = builder.associatedData != null ? BaseEncoding.base64Url().encode(builder.associatedData) : null;
    }

    private static boolean intShouldBeBetweenLimitsInclusive(int property, int fromInclusive, int toInclusive) {
        return property >= fromInclusive && property <= toInclusive;
    }

    @Override
    protected Map<String, Object> getOptions() {
        ImmutableMap.Builder argon2Parameters = ImmutableMap.builder().put((Object)"hashLengthBytes", (Object)this.hashLengthBytes).put((Object)"hashType", (Object)this.hashType.toString()).put((Object)"parallelism", (Object)this.parallelism).put((Object)"iterations", (Object)this.iterations).put((Object)"memoryCostKib", (Object)this.memoryCostKib);
        if (this.associatedData != null) {
            argon2Parameters.put((Object)"associatedData", (Object)this.associatedData);
        }
        if (this.version != null) {
            argon2Parameters.put((Object)"version", (Object)this.version.toString());
        }
        return ImmutableMap.of((Object)"argon2Parameters", (Object)argon2Parameters.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Argon2Version {
        VERSION_10,
        VERSION_13;

    }

    public static enum Argon2HashType {
        ARGON2_D,
        ARGON2_ID,
        ARGON2_I;

    }

    public static class Builder {
        private int hashLengthBytes;
        private Argon2HashType hashType;
        private int parallelism;
        private int iterations;
        private int memoryCostKib;
        private Argon2Version version;
        private byte[] associatedData;

        private Builder() {
        }

        public Builder setHashLengthBytes(int hashLengthBytes) {
            this.hashLengthBytes = hashLengthBytes;
            return this;
        }

        public Builder setHashType(Argon2HashType hashType) {
            this.hashType = hashType;
            return this;
        }

        public Builder setParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder setIterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder setMemoryCostKib(int memoryCostKib) {
            this.memoryCostKib = memoryCostKib;
            return this;
        }

        public Builder setVersion(Argon2Version version) {
            this.version = version;
            return this;
        }

        public Builder setAssociatedData(byte[] associatedData) {
            this.associatedData = associatedData;
            return this;
        }

        public Argon2 build() {
            return new Argon2(this);
        }
    }
}

