/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.CancelTask;

public class Cosmic1Convention
extends CoordSysBuilder {
    protected static final double RTD = 57.29577951308232;
    protected static final double DTR = Math.PI / 180;

    public static boolean isMine(NetcdfFile ncfile) {
        if (null == ncfile.findDimension("MSL_alt") && null == ncfile.findDimension("time")) {
            return false;
        }
        String center = ncfile.findAttValueIgnoreCase(null, "center", null);
        return center != null && center.equals("UCAR/CDAAC");
    }

    public Cosmic1Convention() {
        this.conventionName = "Cosmic1";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        Attribute leoAtt = ds.findGlobalAttribute("leoId");
        if (leoAtt == null) {
            Variable v;
            if (ds.findVariable("time") == null) {
                double start = ds.readAttributeDouble(null, "start_time", Double.NaN);
                double stop = ds.readAttributeDouble(null, "stop_time", Double.NaN);
                if (Double.isNaN(start) && Double.isNaN(stop)) {
                    double top = ds.readAttributeDouble(null, "toptime", Double.NaN);
                    double bot = ds.readAttributeDouble(null, "bottime", Double.NaN);
                    this.conventionName = "Cosmic2";
                    if (top > bot) {
                        stop = top;
                        start = bot;
                    } else {
                        stop = bot;
                        start = top;
                    }
                }
                Dimension dim = ds.findDimension("MSL_alt");
                Variable dimV = ds.findVariable("MSL_alt");
                Array dimU = dimV.read();
                boolean inscr = dimU.getFloat(1) - dimU.getFloat(0) > 0.0f;
                int n = dim.getLength();
                double incr = (stop - start) / (double)n;
                String timeUnits = "seconds since 1980-01-06 00:00:00";
                VariableDS timeVar = new VariableDS(ds, null, null, "time", DataType.DOUBLE, dim.getShortName(), timeUnits, null);
                ds.addVariable(null, timeVar);
                timeVar.addAttribute(new Attribute("units", timeUnits));
                timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                int dir = ds.readAttributeInteger(null, "irs", 1);
                ArrayDouble.D1 data = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{n});
                if (!inscr) {
                    if (dir == 1) {
                        for (int i = 0; i < n; ++i) {
                            data.set(i, start + (double)i * incr);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            data.set(i, stop - (double)i * incr);
                        }
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        data.set(i, stop - (double)i * incr);
                    }
                }
                timeVar.setCachedData(data, false);
            }
            if ((v = ds.findVariable("Lat")) == null) {
                v = ds.findVariable("GEO_lat");
            }
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            Variable v1 = ds.findVariable("Lon");
            if (v1 == null) {
                v1 = ds.findVariable("GEO_lon");
            }
            v1.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        } else {
            Dimension dim = ds.findDimension("time");
            int n = dim.getLength();
            VariableDS latVar = new VariableDS(ds, null, null, "Lat", DataType.FLOAT, dim.getShortName(), "degree", null);
            latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            ds.addVariable(null, latVar);
            VariableDS lonVar = new VariableDS(ds, null, null, "Lon", DataType.FLOAT, dim.getShortName(), "degree", null);
            lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            ds.addVariable(null, lonVar);
            VariableDS altVar = new VariableDS(ds, null, null, "MSL_alt", DataType.FLOAT, dim.getShortName(), "meter", null);
            altVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
            ds.addVariable(null, altVar);
            ArrayFloat.D1 latData = (ArrayFloat.D1)Array.factory(DataType.FLOAT, new int[]{n});
            ArrayFloat.D1 lonData = (ArrayFloat.D1)Array.factory(DataType.FLOAT, new int[]{n});
            ArrayFloat.D1 altData = (ArrayFloat.D1)Array.factory(DataType.FLOAT, new int[]{n});
            ArrayDouble.D1 timeData = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{n});
            this.conventionName = "Cosmic3";
            int iyr = ds.readAttributeInteger(null, "year", 2009);
            int mon = ds.readAttributeInteger(null, "month", 0);
            int iday = ds.readAttributeInteger(null, "day", 0);
            int ihr = ds.readAttributeInteger(null, "hour", 0);
            int min = ds.readAttributeInteger(null, "minute", 0);
            int sec = ds.readAttributeInteger(null, "second", 0);
            double start = ds.readAttributeDouble(null, "startTime", Double.NaN);
            double stop = ds.readAttributeDouble(null, "stopTime", Double.NaN);
            double incr = (stop - start) / (double)n;
            boolean t = false;
            double dtheta = this.gast(iyr, mon, iday, ihr, min, sec, (double)t);
            Variable tVar = ds.findVariable("time");
            String timeUnits = "seconds since 1980-01-06 00:00:00";
            tVar.removeAttributeIgnoreCase("valid_range");
            tVar.removeAttributeIgnoreCase("units");
            tVar.addAttribute(new Attribute("units", timeUnits));
            tVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            Variable v = ds.findVariable("xLeo");
            Array xLeo = v.read();
            v = ds.findVariable("yLeo");
            Array yLeo = v.read();
            v = ds.findVariable("zLeo");
            Array zLeo = v.read();
            Array tArray = tVar.read();
            double pi = 3.1415926;
            double a = 6378.137;
            double b = 6356.7523142;
            IndexIterator iiter0 = xLeo.getIndexIterator();
            IndexIterator iiter1 = yLeo.getIndexIterator();
            IndexIterator iiter2 = zLeo.getIndexIterator();
            int i = 0;
            while (iiter0.hasNext()) {
                double[] v_inertial = new double[]{iiter0.getDoubleNext(), iiter1.getDoubleNext(), iiter2.getDoubleNext()};
                double[] uvz = new double[]{0.0, 0.0, 1.0};
                double[] v_ecf = this.spin(v_inertial, uvz, -1.0 * dtheta);
                double[] llh = this.xyzell(a, b, v_ecf);
                double llt = tArray.getDouble(i);
                latData.set(i, (float)llh[0]);
                lonData.set(i, (float)llh[1]);
                altData.set(i, (float)llh[2]);
                timeData.set(i, start + (double)i * incr);
                ++i;
            }
            latVar.setCachedData(latData, false);
            lonVar.setCachedData(lonData, false);
            altVar.setCachedData(altData, false);
            tVar.setCachedData(timeData, false);
        }
        ds.finish();
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        String name = v.getShortName();
        if (name.equals("time")) {
            return AxisType.Time;
        }
        if (name.equals("Lat") || name.equals("GEO_lat")) {
            return AxisType.Lat;
        }
        if (name.equals("Lon") || name.equals("GEO_lon")) {
            return AxisType.Lon;
        }
        if (name.equals("MSL_alt")) {
            return AxisType.Height;
        }
        return null;
    }

    public double[] xyzell(double a, double b, double[] xstat) {
        double[] dxell = new double[3];
        double[] xstell = new double[3];
        double[] xp = new double[3];
        double e2 = (a * a - b * b) / (a * a);
        double s = Math.sqrt(xstat[0] * xstat[0] + xstat[1] * xstat[1]);
        double rlam = Math.atan2(xstat[1], xstat[0]);
        double zps = xstat[2] / s;
        double h = Math.sqrt(xstat[0] * xstat[0] + xstat[1] * xstat[1] + xstat[2] * xstat[2]) - a;
        double phi = Math.atan(zps / (1.0 - e2 * a / (a + h)));
        int niter = 0;
        for (int i = 1; i <= 10000000; ++i) {
            double n = a / Math.sqrt(1.0 - e2 * Math.sin(phi) * Math.sin(phi));
            double hp = h;
            double phip = phi;
            h = s / Math.cos(phi) - n;
            phi = Math.atan(zps / (1.0 - e2 * n / (n + h)));
            ++niter;
            if (Math.abs(phip - phi) <= 1.0E-11 && Math.abs(hp - h) <= 1.0E-5) break;
            if (niter < 10) continue;
            phi = -999.0;
            rlam = -999.0;
            h = -999.0;
            break;
        }
        xstell[0] = phi * 180.0 / 3.1415926;
        xstell[1] = rlam * 180.0 / 3.1415926;
        xstell[2] = h;
        return xstell;
    }

    public double gast(int iyr, int imon, int iday, int ihr, int imin, double sec, double dsec) {
        double djd = this.juday(imon, iday, iyr);
        double tu = (djd - 2451545.0) / 36525.0;
        double gmst = 24110.54841 + 8640184.812866 * tu + 0.093104 * tu * tu - 6.2E-6 * Math.pow(tu, 3.0);
        double utco = (double)(ihr * 3600 + imin * 60) + sec;
        double theta = this.togreenw(dsec, utco, gmst);
        return theta;
    }

    public double juday(int M, int D, int Y) {
        double IY = Y - (12 - M) / 10;
        double IM = M + 1 + 12 * ((12 - M) / 10);
        double I = IY / 100.0;
        double J = 2.0 - I + I / 4.0 + (double)Math.round(365.25 * IY) + (double)Math.round(30.6001 * IM);
        double JD = J + (double)D + 1720994.5;
        return JD;
    }

    public double togreenw(double rectt, double utco, double gmst) {
        double pi = Math.acos(-1.0);
        double utc = (utco + rectt) * 1.0027379093;
        gmst += utc;
        while (gmst < 0.0) {
            gmst += 86400.0;
        }
        while (gmst > 86400.0) {
            gmst -= 86400.0;
        }
        double theta = gmst * 2.0 * pi / 86400.0;
        return theta;
    }

    public double[] spin(double[] v1, double[] vs, double a) {
        int i;
        double[] v2 = new double[3];
        double[] vsn = new double[3];
        double[] v3 = new double[3];
        double vsabs = Math.sqrt(vs[0] * vs[0] + vs[1] * vs[1] + vs[2] * vs[2]);
        for (int i2 = 0; i2 < 3; ++i2) {
            vsn[i2] = vs[i2] / vsabs;
        }
        double a1 = Math.cos(a);
        double a2 = 1.0 - a1;
        double a3 = Math.sin(a);
        double[][] s = new double[3][3];
        s[0][0] = a2 * vsn[0] * vsn[0] + a1;
        s[0][1] = a2 * vsn[0] * vsn[1] - a3 * vsn[2];
        s[0][2] = a2 * vsn[0] * vsn[2] + a3 * vsn[1];
        s[1][0] = a2 * vsn[1] * vsn[0] + a3 * vsn[2];
        s[1][1] = a2 * vsn[1] * vsn[1] + a1;
        s[1][2] = a2 * vsn[1] * vsn[2] - a3 * vsn[0];
        s[2][0] = a2 * vsn[2] * vsn[0] - a3 * vsn[1];
        s[2][1] = a2 * vsn[2] * vsn[1] + a3 * vsn[0];
        s[2][2] = a2 * vsn[2] * vsn[2] + a1;
        for (i = 0; i < 3; ++i) {
            v3[i] = s[i][0] * v1[0] + s[i][1] * v1[1] + s[i][2] * v1[2];
        }
        for (i = 0; i < 3; ++i) {
            v2[i] = v3[i];
        }
        return v2;
    }

    public double[] execute(double[] eci, double julian) {
        double d__2;
        double tu;
        double Xi = eci[0];
        double Yi = eci[1];
        double Zi = eci[2];
        double[] ecef = new double[3];
        double tday = (int)(julian / 86400.0);
        double tsec = julian - tday * 86400.0;
        double t = tday - 10957.5;
        double tfrac = tsec / 86400.0;
        double dat = t;
        double d__1 = tu = dat / 36525.0;
        double d__3 = d__2 = tu;
        double gmst = tu * 8640184.812866 + 24110.54841 + d__1 * d__1 * 0.093104 - d__3 * (d__2 * d__2) * 6.2E-6;
        d__1 = tu;
        double omega = tu * 5.098097E-6 + 86636.55536790872 - d__1 * d__1 * 5.09E-10;
        double da = 0.0;
        gmst = gmst + omega * tfrac + da * 57.29577951308232 * 86400.0 / 360.0;
        if ((gmst %= 86400.0) < 0.0) {
            gmst += 86400.0;
        }
        gmst = gmst / 86400.0 * 360.0;
        double GHA = gmst *= Math.PI / 180;
        double c = Math.cos(GHA);
        double s = Math.sin(GHA);
        double X = c * Xi + s * Yi;
        double Y = -s * Xi + c * Yi;
        ecef[0] = X;
        ecef[1] = Y;
        ecef[2] = Zi;
        return ecef;
    }

    public static double[] ECFtoLLA(double x, double y, double z, double a, double b) {
        double longitude = Math.atan2(y, x);
        double ePrimeSquared = (a * a - b * b) / (b * b);
        double p = Math.sqrt(x * x + y * y);
        double theta = Math.atan(z * a / (p * b));
        double sineTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double f = 0.0033528106647474805;
        double e2 = 2.0 * f - f * f;
        double top = z + ePrimeSquared * b * sineTheta * sineTheta * sineTheta;
        double bottom = p - e2 * a * cosTheta * cosTheta * cosTheta;
        double geodeticLat = Math.atan(top / bottom);
        double sineLat = Math.sin(geodeticLat);
        double N = a / Math.sqrt(1.0 - e2 * sineLat * sineLat);
        double altitude = p / Math.cos(geodeticLat) - N;
        if (longitude > Math.PI) {
            longitude -= Math.PI * 2;
        } else if (longitude < -Math.PI) {
            longitude += Math.PI * 2;
        }
        return new double[]{geodeticLat, longitude, altitude};
    }
}

