/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.misc.index.BPIndexReorderer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.SetOnce;

public final class BPReorderingMergePolicy
extends FilterMergePolicy {
    static final String REORDERED = "bp.reordered";
    private final BPIndexReorderer reorderer;
    private int minNaturalMergeNumDocs = 1;
    private float minNaturalMergeRatioFromBiggestSegment = 0.0f;

    public BPReorderingMergePolicy(MergePolicy in, BPIndexReorderer reorderer) {
        super(in);
        this.reorderer = reorderer;
    }

    public void setMinNaturalMergeNumDocs(int minNaturalMergeNumDocs) {
        if (minNaturalMergeNumDocs < 1) {
            throw new IllegalArgumentException("minNaturalMergeNumDocs must be at least 1, got " + minNaturalMergeNumDocs);
        }
        this.minNaturalMergeNumDocs = minNaturalMergeNumDocs;
    }

    public void setMinNaturalMergeRatioFromBiggestSegment(float minNaturalMergeRatioFromBiggestSegment) {
        if (!(minNaturalMergeRatioFromBiggestSegment >= 0.0f) || !(minNaturalMergeRatioFromBiggestSegment < 1.0f)) {
            throw new IllegalArgumentException("minNaturalMergeRatioFromBiggestSegment must be in [0, 1), got " + minNaturalMergeRatioFromBiggestSegment);
        }
        this.minNaturalMergeRatioFromBiggestSegment = minNaturalMergeRatioFromBiggestSegment;
    }

    private MergePolicy.MergeSpecification maybeReorder(MergePolicy.MergeSpecification spec, boolean forced, SegmentInfos infos) {
        int minNumDocs;
        if (spec == null) {
            return null;
        }
        if (forced) {
            minNumDocs = 1;
        } else {
            int maxMaxDoc = 0;
            if (infos != null) {
                for (SegmentCommitInfo sci : infos) {
                    maxMaxDoc = Math.max(sci.info.maxDoc(), maxMaxDoc);
                }
            }
            minNumDocs = Math.max(this.minNaturalMergeNumDocs, (int)((double)this.minNaturalMergeRatioFromBiggestSegment * (double)maxMaxDoc));
        }
        MergePolicy.MergeSpecification newSpec = new MergePolicy.MergeSpecification();
        for (final MergePolicy.OneMerge oneMerge : spec.merges) {
            newSpec.add(new MergePolicy.OneMerge(oneMerge){
                private final SetOnce<Boolean> reordered;
                {
                    super(arg0);
                    this.reordered = new SetOnce();
                }

                public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                    return oneMerge.wrapForMerge(reader);
                }

                public Sorter.DocMap reorder(CodecReader reader, Directory dir) throws IOException {
                    Sorter.DocMap docMap = null;
                    if (reader.numDocs() >= minNumDocs) {
                        try {
                            docMap = BPReorderingMergePolicy.this.reorderer.computeDocMap(reader, dir);
                        }
                        catch (BPIndexReorderer.NotEnoughRAMException notEnoughRAMException) {
                            // empty catch block
                        }
                    }
                    this.reordered.set((Object)(docMap != null ? 1 : 0));
                    return docMap;
                }

                public void setMergeInfo(SegmentCommitInfo info) {
                    Boolean reordered = (Boolean)this.reordered.get();
                    if (reordered == null) {
                        reordered = false;
                    }
                    info.info.addDiagnostics(Collections.singletonMap(BPReorderingMergePolicy.REORDERED, Boolean.toString(reordered)));
                    super.setMergeInfo(info);
                }
            });
        }
        return newSpec;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.maybeReorder(super.findMerges(mergeTrigger, segmentInfos, mergeContext), false, segmentInfos);
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.maybeReorder(super.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, mergeContext), true, segmentInfos);
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.maybeReorder(super.findForcedDeletesMerges(segmentInfos, mergeContext), true, segmentInfos);
    }

    public MergePolicy.MergeSpecification findFullFlushMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.maybeReorder(super.findFullFlushMerges(mergeTrigger, segmentInfos, mergeContext), false, segmentInfos);
    }

    public MergePolicy.MergeSpecification findMerges(CodecReader ... readers) throws IOException {
        return this.maybeReorder(super.findMerges(readers), true, null);
    }
}

