/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.metrics.prometheus.SolrMetric;

public abstract class SolrPrometheusFormatter {
    protected final Map<String, List<CounterSnapshot.CounterDataPointSnapshot>> metricCounters = new HashMap<String, List<CounterSnapshot.CounterDataPointSnapshot>>();
    protected final Map<String, List<GaugeSnapshot.GaugeDataPointSnapshot>> metricGauges = new HashMap<String, List<GaugeSnapshot.GaugeDataPointSnapshot>>();

    public abstract void exportDropwizardMetric(Metric var1, String var2);

    public abstract SolrMetric categorizeMetric(Metric var1, String var2);

    public void exportMeter(String metricName, Meter dropwizardMetric, Labels labels) {
        CounterSnapshot.CounterDataPointSnapshot dataPoint = this.createCounterDatapoint(dropwizardMetric.getCount(), labels);
        this.collectCounterDatapoint(metricName, dataPoint);
    }

    public void exportCounter(String metricName, Counter dropwizardMetric, Labels labels) {
        CounterSnapshot.CounterDataPointSnapshot dataPoint = this.createCounterDatapoint(dropwizardMetric.getCount(), labels);
        this.collectCounterDatapoint(metricName, dataPoint);
    }

    public void exportTimer(String metricName, Timer dropwizardMetric, Labels labels) {
        GaugeSnapshot.GaugeDataPointSnapshot dataPoint = this.createGaugeDatapoint(dropwizardMetric.getSnapshot().getMean(), labels);
        this.collectGaugeDatapoint(metricName, dataPoint);
    }

    public void exportTimerCount(String metricName, Timer dropwizardMetric, Labels labels) {
        CounterSnapshot.CounterDataPointSnapshot dataPoint = this.createCounterDatapoint(dropwizardMetric.getCount(), labels);
        this.collectCounterDatapoint(metricName, dataPoint);
    }

    public void exportGauge(String metricName, Gauge<?> dropwizardMetricRaw, Labels labels) {
        Object dropwizardMetric = dropwizardMetricRaw.getValue();
        if (dropwizardMetric instanceof Number) {
            GaugeSnapshot.GaugeDataPointSnapshot dataPoint = this.createGaugeDatapoint(((Number)dropwizardMetric).doubleValue(), labels);
            this.collectGaugeDatapoint(metricName, dataPoint);
        } else if (dropwizardMetric instanceof HashMap) {
            HashMap itemsMap = (HashMap)dropwizardMetric;
            for (Object item : itemsMap.keySet()) {
                if (!(itemsMap.get(item) instanceof Number)) continue;
                GaugeSnapshot.GaugeDataPointSnapshot dataPoint = this.createGaugeDatapoint(((Number)itemsMap.get(item)).doubleValue(), labels.merge(Labels.of((String[])new String[]{"item", (String)item})));
                this.collectGaugeDatapoint(metricName, dataPoint);
            }
        }
    }

    public CounterSnapshot.CounterDataPointSnapshot createCounterDatapoint(double value, Labels labels) {
        return ((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().value(value).labels(labels)).build();
    }

    public GaugeSnapshot.GaugeDataPointSnapshot createGaugeDatapoint(double value, Labels labels) {
        return ((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().value(value).labels(labels)).build();
    }

    public void collectCounterDatapoint(String metricName, CounterSnapshot.CounterDataPointSnapshot dataPoint) {
        if (!this.metricCounters.containsKey(metricName)) {
            this.metricCounters.put(metricName, new ArrayList());
        }
        this.metricCounters.get(metricName).add(dataPoint);
    }

    public void collectGaugeDatapoint(String metricName, GaugeSnapshot.GaugeDataPointSnapshot dataPoint) {
        if (!this.metricGauges.containsKey(metricName)) {
            this.metricGauges.put(metricName, new ArrayList());
        }
        this.metricGauges.get(metricName).add(dataPoint);
    }

    public MetricSnapshots collect() {
        ArrayList<Object> snapshots = new ArrayList<Object>();
        for (String metricName : this.metricCounters.keySet()) {
            snapshots.add(new CounterSnapshot(new MetricMetadata(metricName), (Collection)this.metricCounters.get(metricName)));
        }
        for (String metricName : this.metricGauges.keySet()) {
            snapshots.add(new GaugeSnapshot(new MetricMetadata(metricName), (Collection)this.metricGauges.get(metricName)));
        }
        return new MetricSnapshots(snapshots);
    }
}

