/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.matrix;

import java.util.Arrays;
import org.carrot2.math.mahout.DenseMatrix;
import org.carrot2.math.mahout.Matrix;
import org.carrot2.math.mahout.SingularValueDecomposition;
import org.carrot2.math.mahout.matrix.DoubleMatrix2D;
import org.carrot2.math.mahout.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.math.matrix.MatrixFactorization;
import org.carrot2.math.matrix.MatrixFactorizationBase;

public class PartialSingularValueDecomposition
extends MatrixFactorizationBase
implements MatrixFactorization {
    protected int k = -1;
    protected static final int DEFAULT_K = -1;
    private double[] S;

    public PartialSingularValueDecomposition(DoubleMatrix2D A) {
        super(A);
    }

    @Override
    public void compute() {
        SingularValueDecomposition svd;
        if (this.A.columns() > this.A.rows()) {
            svd = new SingularValueDecomposition(new DenseMatrix(this.A.viewDice().toArray()));
            this.V = PartialSingularValueDecomposition.toColtMatrix(svd.getU());
            this.U = PartialSingularValueDecomposition.toColtMatrix(svd.getV());
        } else {
            svd = new SingularValueDecomposition(new DenseMatrix(this.A.toArray()));
            this.U = PartialSingularValueDecomposition.toColtMatrix(svd.getU());
            this.V = PartialSingularValueDecomposition.toColtMatrix(svd.getV());
        }
        this.S = svd.getSingularValues();
        if (this.k > 0 && this.k < this.S.length) {
            this.U = this.U.viewPart(0, 0, this.U.rows(), this.k);
            this.V = this.V.viewPart(0, 0, this.V.rows(), this.k);
            this.S = Arrays.copyOf(this.S, this.k);
        }
    }

    private static DenseDoubleMatrix2D toColtMatrix(Matrix m) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(m.rowSize(), m.columnSize());
        for (int r = 0; r < result.rows(); ++r) {
            for (int c = 0; c < result.columns(); ++c) {
                result.setQuick(r, c, m.getQuick(r, c));
            }
        }
        return result;
    }

    public String toString() {
        return "SVD";
    }

    public double[] getSingularValues() {
        return this.S;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }
}

