/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.LittleEndianBitConverter;

public class DataSizeObject
extends StreamObject {
    public long dataSize;

    public DataSizeObject() {
        super(StreamObjectTypeHeaderStart.DataSizeObject);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws IOException {
        if (lengthOfItems != 8) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "DataSize", "Stream Object over-parse error", null);
        }
        this.dataSize = LittleEndianBitConverter.toUInt64(byteArray, currentIndex.get());
        currentIndex.addAndGet(8);
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) {
        ByteUtil.appendByteArrayToListOfByte(byteList, LittleEndianBitConverter.getBytes(this.dataSize));
        return 8;
    }
}

