/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.openai.OpenAiModerationModelName;
import dev.langchain4j.model.openai.spi.OpenAiModerationModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpenAiModerationModel
implements ModerationModel {
    private final OpenAiClient client;
    private final String modelName;
    private final Integer maxRetries;

    public OpenAiModerationModel(String baseUrl, String apiKey, String organizationId, String modelName, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.openai.com/v1");
        if ("demo".equals(apiKey)) {
            baseUrl = "http://langchain4j.dev/demo/openai/v1";
        }
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = OpenAiClient.builder().openAiApiKey(apiKey).baseUrl(baseUrl).organizationId(organizationId).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).userAgent("langchain4j-openai").customHeaders(customHeaders).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)"text-moderation-latest");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public String modelName() {
        return this.modelName;
    }

    public Response<Moderation> moderate(String text) {
        return this.moderateInternal(Collections.singletonList(text));
    }

    private Response<Moderation> moderateInternal(List<String> inputs) {
        ModerationRequest request = ModerationRequest.builder().model(this.modelName).input(inputs).build();
        ModerationResponse response = (ModerationResponse)RetryUtils.withRetry(() -> (ModerationResponse)this.client.moderation(request).execute(), (int)this.maxRetries);
        int i = 0;
        for (ModerationResult moderationResult : response.results()) {
            if (moderationResult.isFlagged().booleanValue()) {
                return Response.from((Object)Moderation.flagged((String)inputs.get(i)));
            }
            ++i;
        }
        return Response.from((Object)Moderation.notFlagged());
    }

    public Response<Moderation> moderate(List<ChatMessage> messages) {
        List<String> inputs = messages.stream().map(ChatMessage::text).collect(Collectors.toList());
        return this.moderateInternal(inputs);
    }

    @Deprecated
    public static OpenAiModerationModel withApiKey(String apiKey) {
        return OpenAiModerationModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiModerationModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OpenAiModerationModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiModerationModelBuilderFactory factory = (OpenAiModerationModelBuilderFactory)iterator.next();
            return (OpenAiModerationModelBuilder)factory.get();
        }
        return new OpenAiModerationModelBuilder();
    }

    public static class OpenAiModerationModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        public OpenAiModerationModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiModerationModelBuilder modelName(OpenAiModerationModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiModerationModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiModerationModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiModerationModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiModerationModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiModerationModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiModerationModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiModerationModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiModerationModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiModerationModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiModerationModel build() {
            return new OpenAiModerationModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.customHeaders);
        }

        public String toString() {
            return "OpenAiModerationModel.OpenAiModerationModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", modelName=" + this.modelName + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

