/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.Locale;
import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;

public class PercentileFunction {
    public static final String name = "percentile";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires 2 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream percValue = params[0];
        double perc = 0.0;
        if (percValue instanceof DoubleValue && percValue instanceof ConstantValue) {
            perc = ((DoubleValue)percValue).getDouble();
            if (perc < 0.0 || perc >= 100.0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires a percentile between [0, 100), " + perc + " found.");
            }
            perc /= 100.0;
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires a constant double value (the percentile) as the first argument.");
        }
        AnalyticsValueStream param = params[1];
        if (param instanceof DateValueStream) {
            return new DatePercentileFunction((DateValueStream)param, perc);
        }
        if (param instanceof IntValueStream) {
            return new IntPercentileFunction((IntValueStream)param, perc);
        }
        if (param instanceof LongValueStream) {
            return new LongPercentileFunction((LongValueStream)param, perc);
        }
        if (param instanceof FloatValueStream) {
            return new FloatPercentileFunction((FloatValueStream)param, perc);
        }
        if (param instanceof DoubleValueStream) {
            return new DoublePercentileFunction((DoubleValueStream)param, perc);
        }
        if (param instanceof StringValueStream) {
            return new StringPercentileFunction((StringValueStream)param, perc);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The percentile function requires a comparable parameter.");
    };

    protected static String createPercentileExpressionString(AnalyticsValueStream param, double perc) {
        return String.format(Locale.ROOT, "%s(%s,%s)", name, perc, param.getExpressionStr());
    }

    static class StringPercentileFunction
    extends StringValue.AbstractStringValue
    implements ReductionFunction {
        private SortedListCollector.SortedStringListCollector collector;
        private double percentile;
        public static final String name = "percentile";
        private final String exprStr;

        public StringPercentileFunction(StringValueStream param, double percentile) {
            this.collector = new SortedListCollector.SortedStringListCollector(param);
            this.percentile = percentile;
            this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
        }

        @Override
        public String getString() {
            int size = this.collector.size();
            return size > 0 ? (String)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : null;
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedStringListCollector)sync.apply(this.collector);
            this.collector.calcPercentile(this.percentile);
        }

        @Override
        public String getName() {
            return "percentile";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DatePercentileFunction
    extends DateValue.AbstractDateValue
    implements ReductionFunction {
        private SortedListCollector.SortedLongListCollector collector;
        private double percentile;
        public static final String name = "percentile";
        private final String exprStr;

        public DatePercentileFunction(LongValueStream param, double percentile) {
            this.collector = new SortedListCollector.SortedLongListCollector(param);
            this.percentile = percentile;
            this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
        }

        @Override
        public long getLong() {
            int size = this.collector.size();
            return size > 0 ? (Long)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : 0L;
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
            this.collector.calcPercentile(this.percentile);
        }

        @Override
        public String getName() {
            return "percentile";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DoublePercentileFunction
    extends DoubleValue.AbstractDoubleValue
    implements ReductionFunction {
        private SortedListCollector.SortedDoubleListCollector collector;
        private double percentile;
        public static final String name = "percentile";
        private final String exprStr;

        public DoublePercentileFunction(DoubleValueStream param, double percentile) {
            this.collector = new SortedListCollector.SortedDoubleListCollector(param);
            this.percentile = percentile;
            this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
        }

        @Override
        public double getDouble() {
            int size = this.collector.size();
            return size > 0 ? (Double)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : 0.0;
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedDoubleListCollector)sync.apply(this.collector);
            this.collector.calcPercentile(this.percentile);
        }

        @Override
        public String getName() {
            return "percentile";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class FloatPercentileFunction
    extends FloatValue.AbstractFloatValue
    implements ReductionFunction {
        private SortedListCollector.SortedFloatListCollector collector;
        private double percentile;
        public static final String name = "percentile";
        private final String exprStr;

        public FloatPercentileFunction(FloatValueStream param, double percentile) {
            this.collector = new SortedListCollector.SortedFloatListCollector(param);
            this.percentile = percentile;
            this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
        }

        @Override
        public float getFloat() {
            int size = this.collector.size();
            return size > 0 ? ((Float)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5))).floatValue() : 0.0f;
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedFloatListCollector)sync.apply(this.collector);
            this.collector.calcPercentile(this.percentile);
        }

        @Override
        public String getName() {
            return "percentile";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class LongPercentileFunction
    extends LongValue.AbstractLongValue
    implements ReductionFunction {
        private SortedListCollector.SortedLongListCollector collector;
        private double percentile;
        public static final String name = "percentile";
        private final String exprStr;

        public LongPercentileFunction(LongValueStream param, double percentile) {
            this.collector = new SortedListCollector.SortedLongListCollector(param);
            this.percentile = percentile;
            this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
        }

        @Override
        public long getLong() {
            int size = this.collector.size();
            return size > 0 ? (Long)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : 0L;
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
            this.collector.calcPercentile(this.percentile);
        }

        @Override
        public String getName() {
            return "percentile";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class IntPercentileFunction
    extends IntValue.AbstractIntValue
    implements ReductionFunction {
        private SortedListCollector.SortedIntListCollector collector;
        private double percentile;
        public static final String name = "percentile";
        private final String exprStr;

        public IntPercentileFunction(IntValueStream param, double percentile) {
            this.collector = new SortedListCollector.SortedIntListCollector(param);
            this.percentile = percentile;
            this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
        }

        @Override
        public int getInt() {
            int size = this.collector.size();
            return size > 0 ? (Integer)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : 0;
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedIntListCollector)sync.apply(this.collector);
            this.collector.calcPercentile(this.percentile);
        }

        @Override
        public String getName() {
            return "percentile";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }
}

