/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.query.ResultOrder;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.VersionedRecordIterator;
import org.apache.kafka.streams.state.internals.LogicalKeyValueSegment;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStore;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStoreSegmentValueFormatter;
import org.rocksdb.Snapshot;

public class LogicalSegmentIterator
implements VersionedRecordIterator {
    private final ListIterator<LogicalKeyValueSegment> segmentIterator;
    private final Bytes key;
    private final Long fromTime;
    private final Long toTime;
    private final ResultOrder order;
    private ListIterator<VersionedRecord<byte[]>> iterator;
    private volatile boolean open = true;
    private LogicalKeyValueSegment snapshotOwner = null;
    private Snapshot snapshot = null;

    public LogicalSegmentIterator(ListIterator<LogicalKeyValueSegment> segmentIterator, Bytes key, Long fromTime, Long toTime, ResultOrder order) {
        this.segmentIterator = segmentIterator;
        this.key = key;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.iterator = Collections.emptyListIterator();
        this.order = order;
    }

    @Override
    public void close() {
        this.open = false;
        this.releaseSnapshot();
    }

    @Override
    public boolean hasNext() {
        if (!this.open) {
            throw new IllegalStateException("The iterator is out of scope.");
        }
        boolean hasStillLoad = this.order.equals((Object)ResultOrder.ASCENDING) ? this.iterator.hasPrevious() : this.iterator.hasNext();
        return hasStillLoad || this.maybeFillIterator();
    }

    @Override
    public Object next() {
        if (this.hasNext()) {
            return this.order.equals((Object)ResultOrder.ASCENDING) ? this.iterator.previous() : this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    private boolean maybeFillIterator() {
        ArrayList<VersionedRecord<byte[]>> queryResults = new ArrayList<VersionedRecord<byte[]>>();
        while (this.segmentIterator.hasNext()) {
            byte[] rawSegmentValue;
            LogicalKeyValueSegment segment = this.segmentIterator.next();
            if (this.snapshot == null) {
                this.snapshotOwner = segment;
                this.snapshot = this.snapshotOwner.getSnapshot();
            }
            if ((rawSegmentValue = segment.get(this.key, this.snapshot)) != null) {
                if (segment.id() == -1L) {
                    long recordTimestamp = RocksDBVersionedStore.LatestValueFormatter.getTimestamp(rawSegmentValue);
                    if (recordTimestamp <= this.toTime) {
                        queryResults.add(new VersionedRecord<byte[]>(RocksDBVersionedStore.LatestValueFormatter.getValue(rawSegmentValue), recordTimestamp));
                    }
                } else {
                    List<RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult> searchResults = RocksDBVersionedStoreSegmentValueFormatter.deserialize(rawSegmentValue).findAll(this.fromTime, this.toTime);
                    for (RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult searchResult : searchResults) {
                        queryResults.add(new VersionedRecord<byte[]>(searchResult.value(), searchResult.validFrom(), searchResult.validTo()));
                    }
                }
            }
            if (queryResults.isEmpty()) continue;
            break;
        }
        if (!queryResults.isEmpty()) {
            this.iterator = this.order.equals((Object)ResultOrder.ASCENDING) ? queryResults.listIterator(queryResults.size()) : queryResults.listIterator();
            return true;
        }
        this.releaseSnapshot();
        return false;
    }

    private void releaseSnapshot() {
        if (this.snapshot != null) {
            this.snapshotOwner.releaseSnapshot(this.snapshot);
            this.snapshot = null;
        }
    }
}

