/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.signatureengine.keyparsers;

import de.rub.nds.signatureengine.SignatureEngine;
import de.rub.nds.signatureengine.keyparsers.KeyParser;
import de.rub.nds.signatureengine.keyparsers.KeyParserException;
import de.rub.nds.signatureengine.keyparsers.PemUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;

public class DefaultKeyParser
implements KeyParser {
    @Override
    public final PrivateKey parse(byte[] keyBytes, SignatureEngine.KeyType keyType) throws KeyParserException {
        PrivateKey privateKey = null;
        switch (keyType) {
            case PEM_ENCODED: {
                privateKey = this.parsePemKey(keyBytes);
                break;
            }
            default: {
                throw new KeyParserException("Key type " + (Object)((Object)keyType) + " not supported by key parser!");
            }
        }
        return privateKey;
    }

    protected PrivateKey parsePemKey(byte[] keyBytes) throws KeyParserException {
        try {
            ByteArrayInputStream keyBytesInputSteam = new ByteArrayInputStream(keyBytes);
            return PemUtil.readPrivateKey(keyBytesInputSteam);
        }
        catch (IOException e) {
            throw new KeyParserException(e);
        }
    }
}

