/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgbulkloader;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgbulkloader.Messages;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderData;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderMeta;

public class PGBulkLoader
extends BaseStep
implements StepInterface {
    private PGBulkLoaderMeta meta;
    private PGBulkLoaderData data;

    public PGBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String getCopyCommand(RowMetaInterface rm, Object[] r) throws KettleException {
        DatabaseMeta dm = this.meta.getDatabaseMeta();
        String loadAction = this.meta.getLoadAction();
        StringBuffer contents = new StringBuffer(500);
        String tableName = dm.getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
        if (loadAction.equalsIgnoreCase("truncate")) {
            contents.append("TRUNCATE TABLE ");
            contents.append(tableName + ";");
            contents.append(Const.CR);
        }
        contents.append("COPY ");
        contents.append(tableName);
        contents.append(" ( ");
        String[] streamFields = this.meta.getFieldStream();
        String[] tableFields = this.meta.getFieldTable();
        if (streamFields == null || streamFields.length == 0) {
            throw new KettleException("No fields defined to load to database");
        }
        for (int i = 0; i < streamFields.length; ++i) {
            if (i != 0) {
                contents.append(", ");
            }
            contents.append(dm.quoteField(tableFields[i]));
        }
        contents.append(" ) ");
        contents.append(" FROM STDIN");
        contents.append(" WITH CSV DELIMITER AS '").append(this.meta.getDelimiter()).append("' QUOTE AS '").append(this.meta.getEnclosure()).append("'");
        contents.append(";").append(Const.CR);
        return contents.toString();
    }

    public String createCommandLine(PGBulkLoaderMeta meta, boolean password) throws KettleException {
        StringBuffer sb = new StringBuffer(300);
        if (meta.getPsqlpath() != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getPsqlpath()));
                String psqlexec = KettleVFS.getFilename((FileObject)fileObject);
                sb.append(psqlexec);
            }
            catch (IOException ex) {
                throw new KettleException("Error retrieving sqlldr string", (Throwable)ex);
            }
        } else {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "psql defaults to system path", new Object[0]);
            }
            sb.append("psql");
        }
        DatabaseMeta dm = meta.getDatabaseMeta();
        if (dm != null) {
            String hostname = this.environmentSubstitute(Const.NVL((String)dm.getHostname(), (String)""));
            String portnum = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)""));
            sb.append(" -h ");
            sb.append(hostname);
            sb.append(" -p ");
            sb.append(portnum);
            String dns = Const.NVL((String)dm.getDatabaseName(), (String)"");
            sb.append(" -d ");
            String overrideName = meta.getDbNameOverride();
            if (Const.isEmpty((String)Const.rtrim((String)overrideName))) {
                sb.append(this.environmentSubstitute(dns));
            } else {
                sb.append(this.environmentSubstitute(overrideName));
            }
        } else {
            throw new KettleException("No connection specified");
        }
        return sb.toString();
    }

    public boolean execute(PGBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            String cmd = this.createCommandLine(meta, true);
            this.logBasic("Executing command: " + cmd);
            this.data.psqlProcess = rt.exec(cmd);
            this.data.errorLogger = new StreamLogger(this.data.psqlProcess.getErrorStream(), "ERROR");
            this.data.outputLogger = new StreamLogger(this.data.psqlProcess.getInputStream(), "OUTPUT");
            this.data.pgOutputStream = this.data.psqlProcess.getOutputStream();
            new Thread((Runnable)this.data.errorLogger).start();
            new Thread((Runnable)this.data.outputLogger).start();
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing psql : " + this.createCommandLine(meta, false), (Throwable)ex);
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PGBulkLoaderMeta)smi;
        this.data = (PGBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                this.data.pgOutputStream.flush();
                this.data.pgOutputStream.close();
                int exitVal = this.data.psqlProcess.waitFor();
                this.logBasic(Messages.getString("GPBulkLoader.Log.ExitValuePsqlPath", "" + exitVal));
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.execute(this.meta, true);
                String copyCmd = this.getCopyCommand(this.getInputRowMeta(), r);
                this.logBasic("Launching command: " + copyCmd);
                this.data.pgOutputStream.write(copyCmd.getBytes());
            }
            this.writeRowToPostgres(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(Messages.getString("GPBulkLoader.Log.ErrorInStep"), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void writeRowToPostgres(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            block15: for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    this.data.pgOutputStream.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        this.data.pgOutputStream.write(this.data.quote);
                        if (valueMeta.isStorageBinaryString()) {
                            this.data.pgOutputStream.write((byte[])valueData);
                        } else {
                            this.data.pgOutputStream.write(valueMeta.getString(valueData).getBytes());
                        }
                        this.data.pgOutputStream.write(this.data.quote);
                        continue block15;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.data.pgOutputStream.write((byte[])valueData);
                            continue block15;
                        }
                        this.data.pgOutputStream.write(Long.toString(valueMeta.getInteger(valueData)).getBytes());
                        continue block15;
                    }
                    case 3: {
                        switch (this.data.dateFormatChoices[i]) {
                            case 0: {
                                if (valueMeta.isStorageBinaryString()) {
                                    this.data.pgOutputStream.write((byte[])valueData);
                                    break;
                                }
                                String dateString = valueMeta.getString(valueData);
                                if (dateString == null) continue block15;
                                this.data.pgOutputStream.write(dateString.getBytes());
                                break;
                            }
                            case 1: {
                                String dateString = this.data.dateMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateString == null) continue block15;
                                this.data.pgOutputStream.write(dateString.getBytes());
                                break;
                            }
                            case 2: {
                                String dateTimeString = this.data.dateTimeMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateTimeString != null) {
                                    this.data.pgOutputStream.write(dateTimeString.getBytes());
                                } else {
                                    break;
                                }
                            }
                        }
                        continue block15;
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.data.pgOutputStream.write((byte[])valueData);
                            continue block15;
                        }
                        this.data.pgOutputStream.write(Double.toString(valueMeta.getNumber(valueData)).getBytes());
                        continue block15;
                    }
                    case 1: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.data.pgOutputStream.write((byte[])valueData);
                            continue block15;
                        }
                        this.data.pgOutputStream.write(Double.toString(valueMeta.getNumber(valueData)).getBytes());
                        continue block15;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.data.pgOutputStream.write((byte[])valueData);
                            continue block15;
                        }
                        BigDecimal big = valueMeta.getBigNumber(valueData);
                        if (big == null) continue block15;
                        this.data.pgOutputStream.write(big.toString().getBytes());
                    }
                }
            }
            this.data.pgOutputStream.write(this.data.newline);
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the psql command", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGBulkLoaderMeta)smi;
        this.data = (PGBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.quote = this.meta.getEnclosure() != null ? this.meta.getEnclosure().getBytes() : new byte[0];
            this.data.separator = this.meta.getDelimiter() != null ? this.meta.getDelimiter().getBytes() : new byte[0];
            this.data.newline = Const.CR.getBytes();
            this.data.dateFormatChoices = new int[this.meta.getFieldStream().length];
            for (int i = 0; i < this.data.dateFormatChoices.length; ++i) {
                this.data.dateFormatChoices[i] = Const.isEmpty((String)this.meta.getDateMask()[i]) ? 0 : (this.meta.getDateMask()[i].equalsIgnoreCase("DATE") ? 1 : (this.meta.getDateMask()[i].equalsIgnoreCase("DATETIME") ? 2 : 0));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.logBasic(Messages.getString("System.Log.StartingToRun"));
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                Object var3_1 = null;
            }
            catch (Throwable t) {
                this.logError(Messages.getString("System.Log.UnexpectedError") + " : ");
                this.logError(Const.getStackTracker((Throwable)t));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.dispose(this.meta, this.data);
        this.logSummary();
        this.markStop();
    }
}

