/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.keys;

import java.io.File;
import java.io.FileInputStream;
import java.security.PublicKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.CertsInFilesystemDirectoryResolver;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RetrievePublicKeys {
    public static void main(String[] stringArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        String string = "data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/";
        String string2 = "data/org/apache/xml/security/temp/key/";
        String[] stringArray2 = new String[]{string + "signature-keyname.xml", string + "signature-retrievalmethod-rawx509crt.xml", string + "signature-x509-crt-crl.xml", string + "signature-x509-crt.xml", string + "signature-x509-is.xml", string + "signature-x509-ski.xml", string + "signature-x509-sn.xml", string2 + "signature-retrievalmethod-x509data.xml", string2 + "signature-retrievalmethod-dsavalue.xml", string2 + "retrieval-from-same-doc.xml"};
        int n = 0;
        int n2 = stringArray2.length;
        for (int i = n; i < n2; ++i) {
            String string3 = stringArray2[i];
            System.out.println("#########################################################");
            System.out.println("Try to verify " + string3);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new FileInputStream(string3));
                Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
                Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:KeyInfo[1]", (Node)element);
                KeyInfo keyInfo = new KeyInfo(element2, new File(string3).toURL().toString());
                StorageResolver storageResolver = new StorageResolver((StorageResolverSpi)new CertsInFilesystemDirectoryResolver(string + "certs"));
                keyInfo.addStorageResolver(storageResolver);
                PublicKey publicKey = keyInfo.getPublicKey();
                System.out.println("PublicKey" + (publicKey != null ? " found:" : " not found!!!"));
                if (publicKey != null) {
                    System.out.println("   Format: " + publicKey.getFormat());
                    System.out.println("   Algorithm: " + publicKey.getAlgorithm());
                }
                System.out.println("   Key: " + publicKey);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

