/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class Cluster<T> {
    private List<String> labels = new ArrayList<String>();
    private List<T> documents = new ArrayList<T>();
    private List<Cluster<T>> clusters = new ArrayList<Cluster<T>>();
    private Double score;

    public List<String> getLabels() {
        return this.labels;
    }

    public Cluster<T> addLabel(String label) {
        this.labels.add(label);
        return this;
    }

    public List<T> getDocuments() {
        return this.documents;
    }

    public Cluster<T> addDocument(T document) {
        this.documents.add(document);
        return this;
    }

    public List<Cluster<T>> getClusters() {
        return this.clusters;
    }

    public Cluster<T> addCluster(Cluster<T> cluster) {
        this.clusters.add(cluster);
        return this;
    }

    public Double getScore() {
        return this.score;
    }

    public Cluster<T> setScore(Double score) {
        this.score = score;
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "[\"%s\", docs: %,d%s]", String.join((CharSequence)", ", this.getLabels()), this.getDocuments().size(), this.getScore() == null ? "" : String.format(Locale.ROOT, ", score: %.2f", this.getScore()));
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.equals((Cluster)obj);
    }

    private boolean equals(Cluster<?> that) {
        return Objects.equals(this.getLabels(), that.getLabels()) && Objects.equals(this.getDocuments(), that.getDocuments()) && Objects.equals(this.getClusters(), that.getClusters()) && Objects.equals(this.getScore(), that.getScore());
    }

    public int hashCode() {
        return Objects.hash(this.getLabels(), this.getDocuments(), this.getClusters(), this.getScore());
    }
}

