/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.FileStore;
import org.apache.solr.util.CryptoKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static ArrayList<String> fetchAndShuffleRemoteLiveNodes(CoreContainer coreContainer) {
        Set liveNodes = coreContainer.getZkController().getZkStateReader().getClusterState().getLiveNodes();
        ArrayList<String> l = new ArrayList<String>(liveNodes);
        l.remove(coreContainer.getZkController().getNodeName());
        Collections.shuffle(l, Utils.RANDOM);
        return l;
    }

    public static void validateFiles(FileStore fileStore, List<String> files, boolean validateSignatures, Consumer<String> errs) {
        for (String path : files) {
            try {
                FileStore.FileType type = fileStore.getType(path, true);
                if (type != FileStore.FileType.FILE) {
                    errs.accept("No such file: " + path);
                    continue;
                }
                fileStore.get(path, entry -> {
                    if (entry.getMetaData().signatures == null || entry.getMetaData().signatures.isEmpty()) {
                        errs.accept(path + " has no signature");
                        return;
                    }
                    if (validateSignatures) {
                        try {
                            fileStore.refresh("/_trusted_/keys");
                            FileStoreUtils.validate(fileStore, entry.meta.signatures, entry, false);
                        }
                        catch (Exception e) {
                            log.error("Error validating package artifact", (Throwable)e);
                            errs.accept(e.getMessage());
                        }
                    }
                }, false);
            }
            catch (Exception e) {
                log.error("Error reading file ", (Throwable)e);
                errs.accept("Error reading file " + path + " " + e.getMessage());
            }
        }
    }

    public static void validate(FileStore fileStore, List<String> sigs, FileStore.FileEntry entry, boolean isFirstAttempt) throws SolrException, IOException {
        Map<String, byte[]> keys;
        if (!isFirstAttempt) {
            fileStore.refresh("/_trusted_/keys");
        }
        if ((keys = fileStore.getKeys()) == null || keys.isEmpty()) {
            if (isFirstAttempt) {
                FileStoreUtils.validate(fileStore, sigs, entry, false);
                return;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Filestore does not have any public keys");
        }
        CryptoKeys cryptoKeys = null;
        try {
            cryptoKeys = new CryptoKeys(keys);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing public keys in ZooKeeper");
        }
        for (String sig : sigs) {
            Supplier<String> errMsg = () -> "Signature does not match any public key : " + sig + "sha256 " + entry.getMetaData().sha512;
            if (entry.getBuffer() != null) {
                if (cryptoKeys.verify(sig, entry.getBuffer()) != null) continue;
                if (isFirstAttempt) {
                    FileStoreUtils.validate(fileStore, sigs, entry, false);
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, errMsg.get());
            }
            InputStream inputStream = entry.getInputStream();
            if (cryptoKeys.verify(sig, inputStream) != null) continue;
            if (isFirstAttempt) {
                FileStoreUtils.validate(fileStore, sigs, entry, false);
                return;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, errMsg.get());
        }
    }
}

