/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.CreateReplicaApi;
import org.apache.solr.client.api.model.CreateReplicaRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CreateReplica
extends AdminAPIBase
implements CreateReplicaApi {
    @Inject
    public CreateReplica(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse createReplica(String collectionName, String shardName, CreateReplicaRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request-body is missing");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        String resolvedCollectionName = this.resolveAndValidateAliasIfEnabled(collectionName, Boolean.TRUE.equals(requestBody.followAliases));
        ZkNodeProps remoteMessage = CreateReplica.createRemoteMessage(resolvedCollectionName, shardName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.ADDREPLICA, remoteMessage, requestBody.async);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String shardName, CreateReplicaRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("shard", shardName);
        CreateReplica.insertIfNotNull(remoteMessage, "name", requestBody.name);
        CreateReplica.insertIfNotNull(remoteMessage, "_route_", requestBody.route);
        CreateReplica.insertIfNotNull(remoteMessage, "node", requestBody.node);
        if (CollectionUtil.isNotEmpty((Collection)requestBody.nodeSet)) {
            remoteMessage.put("createNodeSet", String.join((CharSequence)",", requestBody.nodeSet));
        }
        CreateReplica.insertIfNotNull(remoteMessage, "skipNodeAssignment", requestBody.skipNodeAssignment);
        CreateReplica.insertIfNotNull(remoteMessage, "instanceDir", requestBody.instanceDir);
        CreateReplica.insertIfNotNull(remoteMessage, "dataDir", requestBody.dataDir);
        CreateReplica.insertIfNotNull(remoteMessage, "ulogDir", requestBody.ulogDir);
        CreateReplica.insertIfNotNull(remoteMessage, "type", requestBody.type);
        CreateReplica.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
        CreateReplica.insertIfNotNull(remoteMessage, "nrtReplicas", requestBody.nrtReplicas);
        CreateReplica.insertIfNotNull(remoteMessage, "tlogReplicas", requestBody.tlogReplicas);
        CreateReplica.insertIfNotNull(remoteMessage, "pullReplicas", requestBody.pullReplicas);
        CreateReplica.insertIfNotNull(remoteMessage, "followAliases", requestBody.followAliases);
        CreateReplica.insertIfNotNull(remoteMessage, "async", requestBody.async);
        if (requestBody.properties != null) {
            requestBody.properties.entrySet().forEach(entry -> remoteMessage.put("property." + (String)entry.getKey(), entry.getValue()));
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static CreateReplicaRequestBody createRequestBodyFromV1Params(SolrParams params) {
        CreateReplicaRequestBody requestBody = new CreateReplicaRequestBody();
        requestBody.name = params.get("name");
        requestBody.type = params.get("type");
        requestBody.instanceDir = params.get("instanceDir");
        requestBody.dataDir = params.get("dataDir");
        requestBody.ulogDir = params.get("ulogDir");
        requestBody.route = params.get("_route_");
        requestBody.nrtReplicas = params.getInt("nrtReplicas");
        requestBody.tlogReplicas = params.getInt("tlogReplicas");
        requestBody.pullReplicas = params.getInt("pullReplicas");
        requestBody.waitForFinalState = params.getBool("waitForFinalState");
        requestBody.followAliases = params.getBool("followAliases");
        requestBody.async = params.get("async");
        requestBody.node = params.get("node");
        if (params.get("createNodeSet") != null) {
            requestBody.nodeSet = Arrays.asList(params.get("createNodeSet").split(","));
        }
        requestBody.skipNodeAssignment = params.getBool("skipNodeAssignment");
        requestBody.properties = CreateCollection.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
        return requestBody;
    }
}

