/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mail;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mail.MailData;
import org.pentaho.di.trans.steps.mail.MailMeta;
import org.pentaho.di.trans.steps.mail.Messages;

public class Mail
extends BaseStep
implements StepInterface {
    private MailMeta meta;
    private MailData data;

    public Mail(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block67: {
            this.meta = (MailMeta)smi;
            this.data = (MailData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                if (Const.isEmpty((String)this.meta.getDestination())) {
                    throw new KettleException(Messages.getString("Mail.Log.DestinationFieldEmpty"));
                }
                if (Const.isEmpty((String)this.meta.getReplyAddress())) {
                    throw new KettleException(Messages.getString("Mail.Log.ReplyFieldEmpty"));
                }
                if (Const.isEmpty((String)this.meta.getServer())) {
                    throw new KettleException(Messages.getString("Mail.Log.ServerFieldEmpty"));
                }
                if (this.meta.isDynamicFilename() && Const.isEmpty((String)this.meta.getDynamicFieldname())) {
                    throw new KettleException(Messages.getString("Mail.Log.DynamicFilenameFielddEmpty"));
                }
                if (this.meta.isZipFilenameDynamic() && Const.isEmpty((String)this.meta.getDynamicZipFilenameField())) {
                    throw new KettleException(Messages.getString("Mail.Log.DynamicZipFilenameFieldEmpty"));
                }
                if (this.meta.isZipFiles() && Const.isEmpty((String)this.meta.getZipFilename())) {
                    throw new KettleException(Messages.getString("Mail.Log.ZipFilenameEmpty"));
                }
                if (this.meta.isUsingAuthentication()) {
                    if (Const.isEmpty((String)this.meta.getAuthenticationUser())) {
                        throw new KettleException(Messages.getString("Mail.Log.AuthenticationUserFieldEmpty"));
                    }
                    if (Const.isEmpty((String)this.meta.getAuthenticationPassword())) {
                        throw new KettleException(Messages.getString("Mail.Log.AuthenticationPasswordFieldEmpty"));
                    }
                }
                if (this.data.indexOfDestination < 0) {
                    String realDestinationFieldname = this.meta.getDestination();
                    this.data.indexOfDestination = this.data.previousRowMeta.indexOfValue(realDestinationFieldname);
                    if (this.data.indexOfDestination < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindDestinationField", realDestinationFieldname));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getDestinationCc()) && this.data.indexOfDestinationCc < 0) {
                    String realDestinationCcFieldname = this.meta.getDestinationCc();
                    this.data.indexOfDestinationCc = this.data.previousRowMeta.indexOfValue(realDestinationCcFieldname);
                    if (this.data.indexOfDestinationCc < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindDestinationCcField", realDestinationCcFieldname));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getDestinationBCc()) && this.data.indexOfDestinationBCc < 0) {
                    String realDestinationBCcFieldname = this.meta.getDestinationBCc();
                    this.data.indexOfDestinationBCc = this.data.previousRowMeta.indexOfValue(realDestinationBCcFieldname);
                    if (this.data.indexOfDestinationBCc < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindDestinationBCcField", realDestinationBCcFieldname));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getReplyName()) && this.data.indexOfSenderName < 0) {
                    String realSenderName = this.meta.getReplyName();
                    this.data.indexOfSenderName = this.data.previousRowMeta.indexOfValue(realSenderName);
                    if (this.data.indexOfSenderName < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindReplyNameField", realSenderName));
                    }
                }
                if (this.data.indexOfSenderAddress < 0) {
                    String realSenderAddress = this.meta.getReplyAddress();
                    this.data.indexOfSenderAddress = this.data.previousRowMeta.indexOfValue(realSenderAddress);
                    if (this.data.indexOfSenderAddress < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindReplyAddressField", realSenderAddress));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getReplyToAddresses()) && this.data.indexOfReplyToAddresses < 0) {
                    String realReplyToAddresses = this.meta.getReplyToAddresses();
                    this.data.indexOfReplyToAddresses = this.data.previousRowMeta.indexOfValue(realReplyToAddresses);
                    if (this.data.indexOfReplyToAddresses < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindReplyToAddressesField", realReplyToAddresses));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getContactPerson()) && this.data.indexOfContactPerson < 0) {
                    String realContactPerson = this.meta.getContactPerson();
                    this.data.indexOfContactPerson = this.data.previousRowMeta.indexOfValue(realContactPerson);
                    if (this.data.indexOfContactPerson < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindContactPersonField", realContactPerson));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getContactPhone()) && this.data.indexOfContactPhone < 0) {
                    String realContactPhone = this.meta.getContactPhone();
                    this.data.indexOfContactPhone = this.data.previousRowMeta.indexOfValue(realContactPhone);
                    if (this.data.indexOfContactPhone < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindContactPhoneField", realContactPhone));
                    }
                }
                if (this.data.indexOfServer < 0) {
                    String realServer = this.meta.getServer();
                    this.data.indexOfServer = this.data.previousRowMeta.indexOfValue(realServer);
                    if (this.data.indexOfServer < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindServerField", realServer));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getPort()) && this.data.indexOfPort < 0) {
                    String realPort = this.meta.getPort();
                    this.data.indexOfPort = this.data.previousRowMeta.indexOfValue(realPort);
                    if (this.data.indexOfPort < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindPortField", realPort));
                    }
                }
                if (this.meta.isUsingAuthentication()) {
                    if (this.data.indexOfAuthenticationUser < 0) {
                        String realAuthenticationUser = this.meta.getAuthenticationUser();
                        this.data.indexOfAuthenticationUser = this.data.previousRowMeta.indexOfValue(realAuthenticationUser);
                        if (this.data.indexOfAuthenticationUser < 0) {
                            throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindAuthenticationUserField", realAuthenticationUser));
                        }
                    }
                    if (this.data.indexOfAuthenticationPass < 0) {
                        String realAuthenticationPassword = this.meta.getAuthenticationPassword();
                        this.data.indexOfAuthenticationPass = this.data.previousRowMeta.indexOfValue(realAuthenticationPassword);
                        if (this.data.indexOfAuthenticationPass < 0) {
                            throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindAuthenticationPassField", realAuthenticationPassword));
                        }
                    }
                }
                if (!Const.isEmpty((String)this.meta.getSubject()) && this.data.indexOfSubject < 0) {
                    String realSubject = this.meta.getSubject();
                    this.data.indexOfSubject = this.data.previousRowMeta.indexOfValue(realSubject);
                    if (this.data.indexOfSubject < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindSubjectField", realSubject));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getComment()) && this.data.indexOfComment < 0) {
                    String realComment = this.meta.getComment();
                    this.data.indexOfComment = this.data.previousRowMeta.indexOfValue(realComment);
                    if (this.data.indexOfComment < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotFindCommentField", realComment));
                    }
                }
                if (this.meta.isZipFilenameDynamic() && this.data.indexOfDynamicZipFilename < 0) {
                    String realZipFilename = this.meta.getDynamicZipFilenameField();
                    this.data.indexOfDynamicZipFilename = this.data.previousRowMeta.indexOfValue(realZipFilename);
                    if (this.data.indexOfDynamicZipFilename < 0) {
                        throw new KettleException(Messages.getString("Mail.Exception.CouldnotSourceAttachedZipFilenameField", realZipFilename));
                    }
                }
                this.data.zipFileLimit = Const.toLong((String)this.environmentSubstitute(this.meta.getZipLimitSize()), (long)0L);
                if (this.data.zipFileLimit > 0L) {
                    this.data.zipFileLimit *= 0x100000L;
                }
                if (!this.meta.isZipFilenameDynamic()) {
                    this.data.ZipFilename = this.environmentSubstitute(this.meta.getZipFilename());
                }
                if (this.meta.isDynamicFilename()) {
                    if (this.data.indexOfSourceFilename < 0) {
                        String realSourceattachedFilename = this.meta.getDynamicFieldname();
                        this.data.indexOfSourceFilename = this.data.previousRowMeta.indexOfValue(realSourceattachedFilename);
                        if (this.data.indexOfSourceFilename < 0) {
                            throw new KettleException(Messages.getString("Mail.Exception.CouldnotSourceAttachedFilenameField", realSourceattachedFilename));
                        }
                    }
                    if (!Const.isEmpty((String)this.meta.getSourceWildcard()) && this.data.indexOfSourceWildcard < 0) {
                        String realSourceattachedWildcard = this.meta.getDynamicWildcard();
                        this.data.indexOfSourceWildcard = this.data.previousRowMeta.indexOfValue(realSourceattachedWildcard);
                        if (this.data.indexOfSourceWildcard < 0) {
                            throw new KettleException(Messages.getString("Mail.Exception.CouldnotSourceAttachedWildcard", realSourceattachedWildcard));
                        }
                    }
                } else {
                    this.data.realSourceFileFoldername = this.environmentSubstitute(this.meta.getSourceFileFoldername());
                    this.data.realSourceWildcard = this.environmentSubstitute(this.meta.getSourceWildcard());
                }
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                String servername;
                String maildestination = this.data.previousRowMeta.getString(r, this.data.indexOfDestination);
                if (Const.isEmpty((String)maildestination)) {
                    throw new KettleException("Mail.Error.MailDestinationEmpty");
                }
                String maildestinationCc = null;
                if (this.data.indexOfDestinationCc > -1) {
                    maildestinationCc = this.data.previousRowMeta.getString(r, this.data.indexOfDestinationCc);
                }
                String maildestinationBCc = null;
                if (this.data.indexOfDestinationBCc > -1) {
                    maildestinationBCc = this.data.previousRowMeta.getString(r, this.data.indexOfDestinationBCc);
                }
                String mailsendername = null;
                if (this.data.indexOfSenderName > -1) {
                    mailsendername = this.data.previousRowMeta.getString(r, this.data.indexOfSenderName);
                }
                String mailsenderaddress = this.data.previousRowMeta.getString(r, this.data.indexOfSenderAddress);
                String mailreplyToAddresses = null;
                if (this.data.indexOfReplyToAddresses > -1) {
                    mailreplyToAddresses = this.data.previousRowMeta.getString(r, this.data.indexOfReplyToAddresses);
                }
                String contactperson = null;
                if (this.data.indexOfContactPerson > -1) {
                    contactperson = this.data.previousRowMeta.getString(r, this.data.indexOfContactPerson);
                }
                String contactphone = null;
                if (this.data.indexOfContactPhone > -1) {
                    contactphone = this.data.previousRowMeta.getString(r, this.data.indexOfContactPhone);
                }
                if (Const.isEmpty((String)(servername = this.data.previousRowMeta.getString(r, this.data.indexOfServer)))) {
                    throw new KettleException("Mail.Error.MailServerEmpty");
                }
                int port = -1;
                if (this.data.indexOfPort > -1) {
                    port = Const.toInt((String)("" + this.data.previousRowMeta.getInteger(r, this.data.indexOfPort)), (int)-1);
                }
                String authuser = null;
                if (this.data.indexOfAuthenticationUser > -1) {
                    authuser = this.data.previousRowMeta.getString(r, this.data.indexOfAuthenticationUser);
                }
                String authpass = null;
                if (this.data.indexOfAuthenticationPass > -1) {
                    authpass = this.data.previousRowMeta.getString(r, this.data.indexOfAuthenticationPass);
                }
                String subject = null;
                if (this.data.indexOfSubject > -1) {
                    subject = this.data.previousRowMeta.getString(r, this.data.indexOfSubject);
                }
                String comment = null;
                if (this.data.indexOfComment > -1) {
                    comment = this.data.previousRowMeta.getString(r, this.data.indexOfComment);
                }
                this.sendMail(r, servername, port, mailsenderaddress, mailsendername, maildestination, maildestinationCc, maildestinationBCc, contactperson, contactphone, authuser, authpass, subject, comment, mailreplyToAddresses);
                this.putRow(this.getInputRowMeta(), r);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), Messages.getString("Mail.Log.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleException(Messages.getString("Mail.Error.General"), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block67;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "MAIL001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendMail(Object[] r, String server, int port, String senderAddress, String senderName, String destination, String destinationCc, String destinationBCc, String contactPerson, String contactPhone, String authenticationUser, String authenticationPassword, String mailsubject, String comment, String replyToAddresses) throws Exception {
        String realdestinationBCc;
        int i;
        InternetAddress[] address;
        String email_address;
        boolean debug;
        String protocol = "smtp";
        if (this.meta.isUsingAuthentication()) {
            if (this.meta.getSecureConnectionType().equals("TLS")) {
                this.data.props.put("mail.smtp.starttls.enable", "true");
            } else {
                protocol = "smtps";
                this.data.props.put("mail.smtps.quitwait", "false");
            }
        }
        this.data.props.put("mail." + protocol + ".host", server);
        if (port != -1) {
            this.data.props.put("mail." + protocol + ".port", (Object)port);
        }
        boolean bl = debug = this.log.getLogLevel() >= 5;
        if (debug) {
            this.data.props.put("mail.debug", "true");
        }
        if (this.meta.isUsingAuthentication()) {
            this.data.props.put("mail." + protocol + ".auth", "true");
        }
        Session session = Session.getInstance((Properties)this.data.props);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        if (this.meta.isUsePriority()) {
            String priority_int = "1";
            if (this.meta.getPriority().equals("low")) {
                priority_int = "3";
            }
            if (this.meta.getPriority().equals("normal")) {
                priority_int = "2";
            }
            msg.setHeader("X-Priority", priority_int);
            msg.setHeader("Importance", this.meta.getImportance());
        }
        if (Const.isEmpty((String)(email_address = senderAddress))) throw new MessagingException(Messages.getString("Mail.Error.ReplyEmailNotFilled"));
        if (!Const.isEmpty((String)senderName)) {
            email_address = senderName + '<' + email_address + '>';
        }
        msg.setFrom((Address)new InternetAddress(email_address));
        if (!Const.isEmpty((String)replyToAddresses)) {
            String[] reply_Address_List = replyToAddresses.split(" ");
            address = new InternetAddress[reply_Address_List.length];
            for (i = 0; i < reply_Address_List.length; ++i) {
                address[i] = new InternetAddress(reply_Address_List[i]);
            }
            msg.setReplyTo((Address[])address);
        }
        String[] destinations = destination.split(" ");
        address = new InternetAddress[destinations.length];
        for (i = 0; i < destinations.length; ++i) {
            address[i] = new InternetAddress(destinations[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        String realdestinationCc = destinationCc;
        if (!Const.isEmpty((String)realdestinationCc)) {
            String[] destinationsCc = realdestinationCc.split(" ");
            InternetAddress[] addressCc = new InternetAddress[destinationsCc.length];
            for (int i2 = 0; i2 < destinationsCc.length; ++i2) {
                addressCc[i2] = new InternetAddress(destinationsCc[i2]);
            }
            msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
        }
        if (!Const.isEmpty((String)(realdestinationBCc = destinationBCc))) {
            String[] destinationsBCc = realdestinationBCc.split(" ");
            InternetAddress[] addressBCc = new InternetAddress[destinationsBCc.length];
            for (int i3 = 0; i3 < destinationsBCc.length; ++i3) {
                addressBCc[i3] = new InternetAddress(destinationsBCc[i3]);
            }
            msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
        }
        if (mailsubject != null) {
            msg.setSubject(mailsubject);
        }
        msg.setSentDate(new Date());
        StringBuffer messageText = new StringBuffer();
        if (comment != null) {
            messageText.append(comment).append(Const.CR).append(Const.CR);
        }
        if (this.meta.getIncludeDate()) {
            messageText.append(Messages.getString("Mail.Log.Comment.MsgDate") + ": ").append(XMLHandler.date2string((Date)new Date())).append(Const.CR).append(Const.CR);
        }
        if (!(this.meta.isOnlySendComment() || Const.isEmpty((String)contactPerson) && Const.isEmpty((String)contactPhone))) {
            messageText.append(Messages.getString("Mail.Log.Comment.ContactInfo") + " :").append(Const.CR);
            messageText.append("---------------------").append(Const.CR);
            messageText.append(Messages.getString("Mail.Log.Comment.PersonToContact") + " : ").append(contactPerson).append(Const.CR);
            messageText.append(Messages.getString("Mail.Log.Comment.Tel") + "  : ").append(contactPhone).append(Const.CR);
            messageText.append(Const.CR);
        }
        this.data.parts = new MimeMultipart();
        MimeBodyPart part1 = new MimeBodyPart();
        if (this.meta.isUseHTML()) {
            if (!Const.isEmpty((String)this.meta.getEncoding())) {
                part1.setContent((Object)messageText.toString(), "text/html; charset=" + this.meta.getEncoding());
            } else {
                part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
            }
        } else {
            part1.setText(messageText.toString());
        }
        this.data.parts.addBodyPart((BodyPart)part1);
        if (this.meta.isDynamicFilename()) {
            this.setAttachedFilesList(r, this.log);
        } else {
            this.setAttachedFilesList(null, this.log);
        }
        msg.setContent(this.data.parts);
        Transport transport = null;
        try {
            transport = session.getTransport(protocol);
            if (this.meta.isUsingAuthentication()) {
                if (port != -1) {
                    transport.connect(Const.NVL((String)server, (String)""), port, Const.NVL((String)authenticationUser, (String)""), Const.NVL((String)authenticationPassword, (String)""));
                } else {
                    transport.connect(Const.NVL((String)server, (String)""), Const.NVL((String)authenticationUser, (String)""), Const.NVL((String)authenticationPassword, (String)""));
                }
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            Object var29_32 = null;
            if (transport == null) return;
        }
        catch (Throwable throwable) {
            Object var29_33 = null;
            if (transport == null) throw throwable;
            transport.close();
            throw throwable;
        }
        transport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setAttachedFilesList(Object[] r, LogWriter log) throws Exception {
        block48: {
            block44: {
                block43: {
                    realSourceFileFoldername = null;
                    realSourceWildcard = null;
                    sourcefile = null;
                    file = null;
                    zipOutputStream = null;
                    masterZipfile = null;
                    if (this.meta.isZipFilenameDynamic()) {
                        this.data.ZipFilename = this.data.previousRowMeta.getString(r, this.data.indexOfDynamicZipFilename);
                    }
                    if (this.meta.isDynamicFilename()) {
                        if (this.data.indexOfSourceFilename > -1) {
                            realSourceFileFoldername = this.data.previousRowMeta.getString(r, this.data.indexOfSourceFilename);
                        }
                        if (this.data.indexOfSourceWildcard > -1) {
                            realSourceWildcard = this.data.previousRowMeta.getString(r, this.data.indexOfSourceWildcard);
                        }
                    } else {
                        realSourceFileFoldername = this.data.realSourceFileFoldername;
                        realSourceWildcard = this.data.realSourceWildcard;
                    }
                    if (Const.isEmpty((String)realSourceFileFoldername)) break block43;
                    sourcefile = KettleVFS.getFileObject((String)realSourceFileFoldername);
                    if (sourcefile.exists()) {
                        FileSize = 0L;
                        list = null;
                        list = sourcefile.getType() == FileType.FILE ? new FileObject[]{sourcefile} : sourcefile.findFiles((FileSelector)new TextFileSelector(sourcefile.toString(), realSourceWildcard));
                        if (list.length > 0) {
                            zipFiles = this.meta.isZipFiles();
                            if (zipFiles && this.data.zipFileLimit == 0L) {
                                masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.data.ZipFilename);
                                zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                            }
                            for (i = 0; i < list.length; ++i) {
                                file = KettleVFS.getFileObject((String)KettleVFS.getFilename((FileObject)list[i]));
                                if (zipFiles) {
                                    if (this.data.zipFileLimit == 0L) {
                                        zipEntry = new ZipEntry(file.getName().getBaseName());
                                        zipOutputStream.putNextEntry(zipEntry);
                                        inputStream = new BufferedInputStream(file.getContent().getInputStream());
                                        while ((c = inputStream.read()) >= 0) {
                                            zipOutputStream.write(c);
                                        }
                                        inputStream.close();
                                        zipOutputStream.closeEntry();
                                        continue;
                                    }
                                    FileSize += file.getContent().getSize();
                                    continue;
                                }
                                this.addAttachedFilePart(file);
                            }
                            if (zipFiles) {
                                if (log.isDebug()) {
                                    log.logDebug(this.toString(), Messages.getString("Mail.Log.FileSize", "" + FileSize), new Object[0]);
                                }
                                if (log.isDebug()) {
                                    log.logDebug(this.toString(), Messages.getString("Mail.Log.LimitSize", "" + this.data.zipFileLimit), new Object[0]);
                                }
                                if (this.data.zipFileLimit > 0L && FileSize > this.data.zipFileLimit) {
                                    masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.data.ZipFilename);
                                    zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                                    for (i = 0; i < list.length; ++i) {
                                        file = KettleVFS.getFileObject((String)KettleVFS.getFilename((FileObject)list[i]));
                                        zipEntry = new ZipEntry(file.getName().getBaseName());
                                        zipOutputStream.putNextEntry(zipEntry);
                                        inputStream = new BufferedInputStream(file.getContent().getInputStream());
                                        while ((c = inputStream.read()) >= 0) {
                                            zipOutputStream.write(c);
                                        }
                                        inputStream.close();
                                        zipOutputStream.closeEntry();
                                    }
                                }
                                if (this.data.zipFileLimit > 0L && FileSize > this.data.zipFileLimit || this.data.zipFileLimit == 0L) {
                                    file = KettleVFS.getFileObject((String)masterZipfile.getAbsolutePath());
                                    this.addAttachedFilePart(file);
                                    ** GOTO lbl73
                                }
                            }
                        }
                        break block43;
                    }
                    log.logError(this.toString(), Messages.getString("Mail.Error.SourceFileFolderNotExists", realSourceFileFoldername), new Object[0]);
                }
                var18_17 = null;
                if (sourcefile == null) break block44;
                try {
                    sourcefile.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.finish();
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    log.logError(this.toString(), "Unable to close attachement zip file archive : " + e.toString(), new Object[0]);
                }
            }
            break block48;
            {
                catch (Exception e) {
                    log.logError(this.toString(), e.getMessage(), new Object[0]);
                    var18_18 = null;
                    if (sourcefile != null) {
                        try {
                            sourcefile.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (zipOutputStream != null) {
                        try {
                            zipOutputStream.finish();
                            zipOutputStream.close();
                        }
                        catch (IOException e) {
                            log.logError(this.toString(), "Unable to close attachement zip file archive : " + e.toString(), new Object[0]);
                        }
                    }
                }
            }
            catch (Throwable var17_23) {
                var18_19 = null;
                if (sourcefile != null) {
                    try {
                        sourcefile.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.finish();
                        zipOutputStream.close();
                    }
                    catch (IOException e) {
                        log.logError(this.toString(), "Unable to close attachement zip file archive : " + e.toString(), new Object[0]);
                    }
                }
                throw var17_23;
            }
        }
    }

    private void addAttachedFilePart(FileObject file) throws Exception {
        MimeBodyPart files = new MimeBodyPart();
        URLDataSource fds = new URLDataSource(file.getURL());
        files.setDataHandler(new DataHandler((DataSource)fds));
        files.setFileName(file.getName().getBaseName());
        this.data.parts.addBodyPart((BodyPart)files);
        if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), Messages.getString("Mail.Log.AttachedFile", fds.getName()), new Object[0]);
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailMeta)smi;
        this.data = (MailData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    private class TextFileSelector
    implements FileSelector {
        LogWriter log = LogWriter.getInstance();
        String file_wildcard = null;
        String source_folder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.source_folder = sourcefolderin;
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.file_wildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.source_folder)) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if ((info.getFile().getParent().equals(info.getBaseFolder()) || !info.getFile().getParent().equals(info.getBaseFolder()) && Mail.this.meta.isIncludeSubFolders()) && (info.getFile().getType() == FileType.FILE && this.file_wildcard == null || info.getFile().getType() == FileType.FILE && this.file_wildcard != null && Mail.this.GetFileWildcard(short_filename, this.file_wildcard))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                this.log.logError(this.toString(), Messages.getString("Mail.Error.FindingFiles", info.getFile().toString(), e.getMessage()), new Object[0]);
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

