/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.cff.CffFont;
import jogamp.graph.font.typecast.cff.Index;
import jogamp.graph.font.typecast.cff.NameIndex;
import jogamp.graph.font.typecast.cff.StringIndex;
import jogamp.graph.font.typecast.cff.TopDictIndex;
import jogamp.graph.font.typecast.ot.table.Table;

public class CffTable
implements Table {
    private final int _major;
    private final int _minor;
    private final int _hdrSize;
    private final int _offSize;
    private final NameIndex _nameIndex;
    private final TopDictIndex _topDictIndex;
    private final StringIndex _stringIndex;
    private final Index _globalSubrIndex;
    private final CffFont[] _fonts;
    private final byte[] _buf;

    protected CffTable(DataInput dataInput, int n) throws IOException {
        this._buf = new byte[n];
        dataInput.readFully(this._buf);
        DataInput dataInput2 = this.getDataInputForOffset(0);
        this._major = dataInput2.readUnsignedByte();
        this._minor = dataInput2.readUnsignedByte();
        this._hdrSize = dataInput2.readUnsignedByte();
        this._offSize = dataInput2.readUnsignedByte();
        dataInput2 = this.getDataInputForOffset(this._hdrSize);
        this._nameIndex = new NameIndex(dataInput2);
        this._topDictIndex = new TopDictIndex(dataInput2);
        this._stringIndex = new StringIndex(dataInput2);
        this._globalSubrIndex = new Index(dataInput2);
        this._fonts = new CffFont[this._topDictIndex.getCount()];
        for (int i = 0; i < this._topDictIndex.getCount(); ++i) {
            this._fonts[i] = new CffFont(this, i, this._topDictIndex.getTopDict(i));
        }
    }

    public final DataInput getDataInputForOffset(int n) {
        return new DataInputStream(new ByteArrayInputStream(this._buf, n, this._buf.length - n));
    }

    @Override
    public int getType() {
        return 1128678944;
    }

    public NameIndex getNameIndex() {
        return this._nameIndex;
    }

    public StringIndex getStringIndex() {
        return this._stringIndex;
    }

    public Index getGlobalSubrIndex() {
        return this._globalSubrIndex;
    }

    public CffFont getFont(int n) {
        return this._fonts[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'CFF' Table - Compact Font Format\n---------------------------------\n");
        stringBuilder.append("\nName INDEX\n");
        stringBuilder.append(this._nameIndex.toString());
        stringBuilder.append("\nTop DICT INDEX\n");
        stringBuilder.append(this._topDictIndex.toString());
        stringBuilder.append("\nString INDEX\n");
        stringBuilder.append(this._stringIndex.toString());
        stringBuilder.append("\nGlobal Subr INDEX\n");
        stringBuilder.append(this._globalSubrIndex.toString());
        for (int i = 0; i < this._fonts.length; ++i) {
            stringBuilder.append("\nCharStrings INDEX ").append(i).append("\n");
            stringBuilder.append(this._fonts[i].getCharStringsIndex().toString());
        }
        return stringBuilder.toString();
    }
}

