/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.builder.ColumnValueBindingBuilder;

@Internal
public class ColumnValueBindingList
extends ArrayList<ColumnValueBinding>
implements ModelPart.JdbcValueConsumer {
    private final MutatingTableReference mutatingTable;
    private final ColumnValueParameterList parameters;
    private final ParameterUsage parameterUsage;

    public ColumnValueBindingList(MutatingTableReference mutatingTable, ColumnValueParameterList parameters, ParameterUsage parameterUsage) {
        this.mutatingTable = mutatingTable;
        this.parameters = parameters;
        this.parameterUsage = parameterUsage;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void consume(int valueIndex, Object value, SelectableMapping jdbcValueMapping) {
        if (value == null) {
            this.addNullRestriction(jdbcValueMapping);
        } else {
            this.addRestriction(jdbcValueMapping);
        }
    }

    @Internal
    @Incubating
    public void addRestriction(ColumnValueBinding valueBinding) {
        this.add(valueBinding);
    }

    public void addRestriction(SelectableMapping column) {
        this.add(this.createValueBinding(column, column.getWriteExpression()));
    }

    public void addNullRestriction(SelectableMapping column) {
        this.add(this.createValueBinding(column, null));
    }

    protected ColumnValueBinding createValueBinding(SelectableMapping column, @Nullable String customWriteExpression) {
        return ColumnValueBindingBuilder.createValueBinding(customWriteExpression, column, this.mutatingTable, this.parameterUsage, this.parameters::apply);
    }

    public boolean containsColumn(String columnName, JdbcMapping jdbcMapping) {
        ColumnReference reference = new ColumnReference(this.mutatingTable, columnName, jdbcMapping);
        for (int i = 0; i < this.size(); ++i) {
            if (!((ColumnValueBinding)this.get(i)).getColumnReference().equals(reference)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ColumnValueBindingList" + super.toString();
    }
}

