/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public enum ReactiveType {
    NON_REACTIVE(false, null),
    UNI(true, Uni.class),
    MULTI(true, Multi.class),
    STAGE(true, CompletionStage.class);

    private final boolean reactive;
    private final Class<?> type;

    private ReactiveType(boolean reactive, Class<?> type) {
        this.reactive = reactive;
        this.type = type;
    }

    boolean isReactive() {
        return this.reactive;
    }

    public static ReactiveType valueOf(Method method) {
        if (Void.class.equals(method.getReturnType())) {
            return NON_REACTIVE;
        }
        for (ReactiveType reactiveType : ReactiveType.values()) {
            if (!Objects.nonNull(reactiveType.type) || !reactiveType.type.isAssignableFrom(method.getReturnType())) continue;
            return reactiveType;
        }
        return NON_REACTIVE;
    }
}

