/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.KeySetEndpointContextMatcher;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpEndpointContextMatcher
extends KeySetEndpointContextMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpEndpointContextMatcher.class);
    private static final String[] KEYS = new String[]{"PLAIN"};
    private final boolean checkAddress;

    public UdpEndpointContextMatcher() {
        this(true);
    }

    public UdpEndpointContextMatcher(boolean checkAddress) {
        super("udp plain", KEYS);
        this.checkAddress = checkAddress;
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        InetSocketAddress peerAddress2;
        InetSocketAddress peerAddress1;
        if (this.checkAddress && !(peerAddress1 = requestContext.getPeerAddress()).equals(peerAddress2 = responseContext.getPeerAddress()) && !NetworkInterfacesUtil.isMultiAddress(peerAddress1.getAddress())) {
            LOGGER.info("request {}:{} doesn't match {}:{}!", new Object[]{peerAddress1.getAddress().getHostAddress(), peerAddress1.getPort(), peerAddress2.getAddress().getHostAddress(), peerAddress2.getPort()});
            return false;
        }
        return super.isResponseRelatedToRequest(requestContext, responseContext);
    }
}

