/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

public class CipherSuiteParameters {
    private PublicKey publicKey;
    private List<X509Certificate> certificateChain;
    private boolean clientAuthenticationRequired;
    private boolean clientAuthenticationWanted;
    private List<CipherSuite> cipherSuites;
    private List<CertificateType> serverCertTypes;
    private List<CertificateType> clientCertTypes;
    private List<XECDHECryptography.SupportedGroup> supportedGroups;
    private List<SignatureAndHashAlgorithm> signatures;
    private SupportedPointFormatsExtension.ECPointFormat format;
    private SignatureAndHashAlgorithm selectedSignature;

    public CipherSuiteParameters(PublicKey publicKey, List<X509Certificate> certificateChain, boolean clientAuthenticationRequired, boolean clientAuthenticationWanted, List<CipherSuite> cipherSuites, List<CertificateType> serverCertTypes, List<CertificateType> clientCertTypes, List<XECDHECryptography.SupportedGroup> supportedGroups, List<SignatureAndHashAlgorithm> signatures, SupportedPointFormatsExtension.ECPointFormat format) {
        this.publicKey = publicKey;
        this.certificateChain = certificateChain;
        this.clientAuthenticationRequired = clientAuthenticationRequired;
        this.clientAuthenticationWanted = !clientAuthenticationRequired && clientAuthenticationWanted;
        this.cipherSuites = cipherSuites;
        this.serverCertTypes = serverCertTypes;
        this.clientCertTypes = clientCertTypes;
        this.supportedGroups = supportedGroups;
        this.signatures = signatures;
        this.format = format;
    }

    public List<CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public List<CertificateType> getServerCertTypes() {
        return this.serverCertTypes;
    }

    public List<CertificateType> getClientCertTypes() {
        return this.clientCertTypes;
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }

    public List<SignatureAndHashAlgorithm> getSignatures() {
        return this.signatures;
    }

    public SupportedPointFormatsExtension.ECPointFormat getFormat() {
        return this.format;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    public boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public boolean isClientAuthenticationWanted() {
        return this.clientAuthenticationWanted;
    }

    public CipherSuite getSelectedCipherSuite() {
        return this.cipherSuites.get(0);
    }

    public CertificateType getSelectedServerCertificateType() {
        if (this.serverCertTypes.isEmpty()) {
            return null;
        }
        return this.serverCertTypes.get(0);
    }

    public CertificateType getSelectedClientCertificateType() {
        if (this.clientCertTypes.isEmpty()) {
            return null;
        }
        return this.clientCertTypes.get(0);
    }

    public XECDHECryptography.SupportedGroup getSelectedSupportedGroup() {
        if (this.supportedGroups.isEmpty()) {
            return null;
        }
        return this.supportedGroups.get(0);
    }

    public SignatureAndHashAlgorithm getSelectedSignature() {
        return this.selectedSignature;
    }

    public void select(CipherSuite cipherSuite) {
        this.cipherSuites.clear();
        this.cipherSuites.add(cipherSuite);
    }

    public void selectServerCertificateType(CertificateType type) {
        this.serverCertTypes.clear();
        if (type != null) {
            this.serverCertTypes.add(type);
        }
    }

    public void selectClientCertificateType(CertificateType type) {
        this.clientCertTypes.clear();
        if (type != null) {
            this.clientCertTypes.add(type);
        }
    }

    public void selectSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signature) {
        this.selectedSignature = signature;
    }
}

