/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public final class CostRateTableEntry
implements Comparable<CostRateTableEntry> {
    private Date m_endDate;
    private Rate m_standardRate;
    private TimeUnit m_standardRateFormat;
    private Rate m_overtimeRate;
    private TimeUnit m_overtimeRateFormat;
    private Number m_costPerUse;
    public static final CostRateTableEntry DEFAULT_ENTRY = new CostRateTableEntry();

    private CostRateTableEntry() {
        this.m_endDate = DateHelper.LAST_DATE;
        this.m_standardRate = new Rate(0.0, TimeUnit.HOURS);
        this.m_standardRateFormat = TimeUnit.HOURS;
        this.m_overtimeRate = this.m_standardRate;
        this.m_overtimeRateFormat = TimeUnit.HOURS;
        this.m_costPerUse = NumberHelper.getDouble(0.0);
    }

    public CostRateTableEntry(Rate rate, TimeUnit timeUnit, Rate rate2, TimeUnit timeUnit2, Number number, Date date) {
        this.m_endDate = date;
        this.m_standardRate = rate;
        this.m_standardRateFormat = timeUnit;
        this.m_overtimeRate = rate2;
        this.m_overtimeRateFormat = timeUnit2;
        this.m_costPerUse = number;
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public Rate getStandardRate() {
        return this.m_standardRate;
    }

    public TimeUnit getStandardRateFormat() {
        return this.m_standardRateFormat;
    }

    public Rate getOvertimeRate() {
        return this.m_overtimeRate;
    }

    public TimeUnit getOvertimeRateFormat() {
        return this.m_overtimeRateFormat;
    }

    public Number getCostPerUse() {
        return this.m_costPerUse;
    }

    @Override
    public int compareTo(CostRateTableEntry costRateTableEntry) {
        return DateHelper.compare(this.m_endDate, costRateTableEntry.m_endDate);
    }

    public String toString() {
        return "[CostRateTableEntry standardRate=" + String.valueOf(this.m_standardRate) + " overtimeRate=" + String.valueOf(this.m_overtimeRate) + " costPerUse=" + String.valueOf(this.m_costPerUse) + " endDate=" + String.valueOf(this.m_endDate) + "]";
    }
}

