/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import java.util.stream.IntStream;
import scala.math.package$;

public final class ArrayCharSequence
implements CharSequence {
    private final char[] xs;
    private final int start;
    private final int end;

    public ArrayCharSequence(char[] xs, int start, int end) {
        this.xs = xs;
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isEmpty() {
        return CharSequence.super.isEmpty();
    }

    @Override
    public IntStream chars() {
        return CharSequence.super.chars();
    }

    @Override
    public IntStream codePoints() {
        return CharSequence.super.codePoints();
    }

    public char[] xs() {
        return this.xs;
    }

    @Override
    public int length() {
        return package$.MODULE$.max(0, this.end - this.start);
    }

    @Override
    public char charAt(int index) {
        if (0 <= index && index < this.length()) {
            return this.xs()[this.start + index];
        }
        throw new ArrayIndexOutOfBoundsException(index + " is out of bounds (min 0, max " + (this.xs().length - 1) + ")");
    }

    @Override
    public CharSequence subSequence(int start0, int end0) {
        if (start0 < 0) {
            throw new ArrayIndexOutOfBoundsException(start0 + " is out of bounds (min 0, max " + (this.length() - 1) + ")");
        }
        if (end0 > this.length()) {
            throw new ArrayIndexOutOfBoundsException(end0 + " is out of bounds (min 0, max " + (this.xs().length - 1) + ")");
        }
        if (end0 <= start0) {
            return new ArrayCharSequence(this.xs(), 0, 0);
        }
        int newlen = end0 - start0;
        int start1 = this.start + start0;
        return new ArrayCharSequence(this.xs(), start1, start1 + newlen);
    }

    @Override
    public String toString() {
        int end;
        int start = package$.MODULE$.max(this.start, 0);
        if (start >= (end = package$.MODULE$.min(this.xs().length, start + this.length()))) {
            return "";
        }
        return new String(this.xs(), start, end - start);
    }
}

