/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.MutableMap;
import java.io.Serializable;
import java.util.Arrays;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;

public abstract class GenericHashMap<Key, Value>
extends MutableMap<Key, Value> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int limit;
    private Object[] table;

    public GenericHashMap(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear(this.clear$default$1());
    }

    public int used() {
        return this.used;
    }

    public void used_$eq(int x$1) {
        this.used = x$1;
    }

    public int limit() {
        return this.limit;
    }

    public void limit_$eq(int x$1) {
        this.limit = x$1;
    }

    public Object[] table() {
        return this.table;
    }

    public void table_$eq(Object[] x$1) {
        this.table = x$1;
    }

    private void allocate(int capacity) {
        this.table_$eq(new Object[capacity * 2]);
        this.limit_$eq(capacity <= 8 ? capacity - 1 : capacity / this.capacityMultiple);
    }

    private int roundToPower(int n) {
        if (n < 4) {
            return 4;
        }
        if (Integer.bitCount(n) == 1) {
            return n;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n);
    }

    @Override
    public void clear(boolean resetToInitial) {
        this.used_$eq(0);
        if (resetToInitial) {
            this.allocate(this.roundToPower(this.initialCapacity));
            return;
        }
        Arrays.fill(this.table(), null);
    }

    @Override
    public int size() {
        return this.used();
    }

    public boolean isDense() {
        return this.limit() < 8;
    }

    public abstract int hash(Key var1);

    public abstract boolean isEqual(Key var1, Key var2);

    private int index(int x) {
        return x & this.table().length - 2;
    }

    private int firstIndex(Key key) {
        if (this.isDense()) {
            return 0;
        }
        return this.index(this.hash(key));
    }

    private int nextIndex(int idx) {
        return this.index(idx + 2);
    }

    public Key dotty$tools$dotc$util$GenericHashMap$$keyAt(int idx) {
        return (Key)this.table()[idx];
    }

    public Value dotty$tools$dotc$util$GenericHashMap$$valueAt(int idx) {
        return (Value)this.table()[idx + 1];
    }

    private void setKey(int idx, Key key) {
        this.table()[idx] = key;
    }

    private void setValue(int idx, Value value) {
        this.table()[idx + 1] = value;
    }

    @Override
    public Value lookup(Key key) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                return this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        return null;
    }

    @Override
    public void update(Key key, Value value) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                this.setValue(idx, value);
                return;
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        this.setKey(idx, key);
        this.setValue(idx, value);
        this.used_$eq(this.used() + 1);
        if (this.used() > this.limit()) {
            this.growTable();
            return;
        }
    }

    @Override
    public Value remove(Key key) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                Value result = this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
                int hole = idx;
                while ((k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx = this.nextIndex(idx))) != null) {
                    int eidx = this.index(this.hash(k));
                    if (!this.isDense() && this.index(eidx - (hole + 2)) <= this.index(idx - (hole + 2))) continue;
                    this.setKey(hole, k);
                    this.setValue(hole, this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx));
                    hole = idx;
                }
                this.table()[hole] = null;
                this.used_$eq(this.used() - 1);
                return result;
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        return null;
    }

    @Override
    public Value getOrElseUpdate(Key key, Function0<Value> value) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                return this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        Object v = value.apply();
        this.setKey(idx, key);
        this.setValue(idx, v);
        this.used_$eq(this.used() + 1);
        if (this.used() > this.limit()) {
            this.growTable();
        }
        return (Value)v;
    }

    private void addOld(Key key, Value value) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        this.setKey(idx, key);
        this.setValue(idx, value);
    }

    public void copyFrom(Object[] oldTable) {
        if (this.isDense()) {
            Array$.MODULE$.copy((Object)oldTable, 0, (Object)this.table(), 0, oldTable.length);
            return;
        }
        for (int idx = 0; idx < oldTable.length; idx += 2) {
            Object key = oldTable[idx];
            if (key == null) continue;
            this.addOld(key, oldTable[idx + 1]);
        }
    }

    public void growTable() {
        Object[] oldTable = this.table();
        int newLength = this.table().length == 16 ? this.table().length * this.roundToPower(this.capacityMultiple) : this.table().length;
        this.allocate(newLength);
        this.copyFrom(oldTable);
    }

    @Override
    public Iterator<Tuple2<Key, Value>> iterator() {
        return new EntryIterator<Tuple2<Key, Value>>(this){
            private final /* synthetic */ GenericHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Tuple2 entry(int idx) {
                return Tuple2$.MODULE$.apply(this.$outer.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx), this.$outer.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx));
            }
        };
    }

    @Override
    public Iterator<Key> keysIterator() {
        return new EntryIterator<Key>(this){
            private final /* synthetic */ GenericHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
            }
        };
    }

    @Override
    public Iterator<Value> valuesIterator() {
        return new EntryIterator<Value>(this){
            private final /* synthetic */ GenericHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
            }
        };
    }

    public String toString() {
        return this.iterator().map((Function1 & Serializable)x$1 -> {
            Object k = x$1._1();
            Object v = x$1._2();
            return k + " -> " + v;
        }).mkString("HashMap(", ", ", ")");
    }

    public String statsItem(String op) {
        String prefix = this.isDense() ? "HashMap(dense)." : "HashMap.";
        String suffix = this.getClass().getSimpleName();
        return prefix + op + " " + suffix;
    }

    public abstract class EntryIterator<T>
    implements Iterator<T> {
        private int idx;

        public EntryIterator() {
            if (GenericHashMap.this == null) {
                throw new NullPointerException();
            }
            this.idx = 0;
        }

        public <S extends Stepper<?>> S stepper(StepperShape<T, S> shape) {
            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
        }

        public int knownSize() {
            return IterableOnce.knownSize$((IterableOnce)this);
        }

        public Tuple2<Iterator<T>, Iterator<T>> splitAt(int n) {
            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
        }

        public boolean isTraversableAgain() {
            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
        }

        public <U> void foreach(Function1<T, U> f) {
            IterableOnceOps.foreach$((IterableOnceOps)this, f);
        }

        public boolean forall(Function1<T, Object> p) {
            return IterableOnceOps.forall$((IterableOnceOps)this, p);
        }

        public boolean exists(Function1<T, Object> p) {
            return IterableOnceOps.exists$((IterableOnceOps)this, p);
        }

        public int count(Function1<T, Object> p) {
            return IterableOnceOps.count$((IterableOnceOps)this, p);
        }

        public Option<T> find(Function1<T, Object> p) {
            return IterableOnceOps.find$((IterableOnceOps)this, p);
        }

        public <B> B foldLeft(B z, Function2<B, T, B> op) {
            return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
        }

        public <B> B foldRight(B z, Function2<T, B, B> op) {
            return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
        }

        public final <B> B $div$colon(B z, Function2<B, T, B> op) {
            return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
        }

        public final <B> B $colon$bslash(B z, Function2<T, B, B> op) {
            return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
        }

        public <B> B reduce(Function2<B, B, B> op) {
            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
        }

        public <B> B reduceLeft(Function2<B, T, B> op) {
            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
        }

        public <B> B reduceRight(Function2<T, B, B> op) {
            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
        }

        public boolean nonEmpty() {
            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
        }

        public int size() {
            return IterableOnceOps.size$((IterableOnceOps)this);
        }

        public final <B> void copyToBuffer(Buffer<B> dest) {
            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
        }

        public <B> int copyToArray(Object dest) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
        }

        public <B> int copyToArray(Object dest, int start) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
        }

        public <B> int copyToArray(Object dest, int start, int n) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
        }

        public <B> T min(Ordering<B> ord) {
            return (T)IterableOnceOps.min$((IterableOnceOps)this, ord);
        }

        public <B> Option<T> minOption(Ordering<B> ord) {
            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
        }

        public <B> T max(Ordering<B> ord) {
            return (T)IterableOnceOps.max$((IterableOnceOps)this, ord);
        }

        public <B> Option<T> maxOption(Ordering<B> ord) {
            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
        }

        public <B> T maxBy(Function1<T, B> f, Ordering<B> ord) {
            return (T)IterableOnceOps.maxBy$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<T> maxByOption(Function1<T, B> f, Ordering<B> ord) {
            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
        }

        public <B> T minBy(Function1<T, B> f, Ordering<B> ord) {
            return (T)IterableOnceOps.minBy$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<T> minByOption(Function1<T, B> f, Ordering<B> ord) {
            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
            return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
        }

        public <B> boolean corresponds(IterableOnce<B> that, Function2<T, B, Object> p) {
            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
        }

        public final String mkString(String start, String sep, String end) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
        }

        public final String mkString(String sep) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
        }

        public final String mkString() {
            return IterableOnceOps.mkString$((IterableOnceOps)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public final StringBuilder addString(StringBuilder b, String sep) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
        }

        public final StringBuilder addString(StringBuilder b) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
        }

        public <C1> C1 to(Factory<T, C1> factory) {
            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
        }

        public final Iterator<T> toIterator() {
            return IterableOnceOps.toIterator$((IterableOnceOps)this);
        }

        public List<T> toList() {
            return IterableOnceOps.toList$((IterableOnceOps)this);
        }

        public Vector<T> toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        public <K, V> Map<K, V> toMap(.less.colon.less<T, Tuple2<K, V>> ev) {
            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
        }

        public <B> Set<B> toSet() {
            return IterableOnceOps.toSet$((IterableOnceOps)this);
        }

        public Seq<T> toSeq() {
            return IterableOnceOps.toSeq$((IterableOnceOps)this);
        }

        public IndexedSeq<T> toIndexedSeq() {
            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
        }

        public final Stream<T> toStream() {
            return IterableOnceOps.toStream$((IterableOnceOps)this);
        }

        public final <B> Buffer<B> toBuffer() {
            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$1);
        }

        public Iterable<T> reversed() {
            return IterableOnceOps.reversed$((IterableOnceOps)this);
        }

        public final boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public final Iterator<T> iterator() {
            return Iterator.iterator$((Iterator)this);
        }

        public Option<T> nextOption() {
            return Iterator.nextOption$((Iterator)this);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public BufferedIterator<T> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator<B> padTo(int len, B elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public int indexWhere(Function1<T, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public int indexWhere$default$2() {
            return Iterator.indexWhere$default$2$((Iterator)this);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public final int length() {
            return Iterator.length$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public Iterator<T> filter(Function1<T, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public Iterator<T> filterNot(Function1<T, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public Iterator<T> filterImpl(Function1<T, Object> p, boolean isFlipped) {
            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
        }

        public Iterator<T> withFilter(Function1<T, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public Iterator<T> distinct() {
            return Iterator.distinct$((Iterator)this);
        }

        public <B> Iterator<T> distinctBy(Function1<T, B> f) {
            return Iterator.distinctBy$((Iterator)this, f);
        }

        public <B> Iterator<B> map(Function1<T, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> flatMap(Function1<T, IterableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public <B> Iterator<B> flatten(Function1<T, IterableOnce<B>> ev) {
            return Iterator.flatten$((Iterator)this, ev);
        }

        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
            return Iterator.concat$((Iterator)this, xs);
        }

        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
            return Iterator.$plus$plus$((Iterator)this, xs);
        }

        public Iterator<T> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<T> takeWhile(Function1<T, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Iterator<T> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<T> dropWhile(Function1<T, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<T> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<T> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<Tuple2<T, B>> zip(IterableOnce<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public Iterator<Tuple2<T, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B> boolean sameElements(IterableOnce<B> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <U> Iterator<T> tapEach(Function1<T, U> f) {
            return Iterator.tapEach$((Iterator)this, f);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public Iterator seq() {
            return Iterator.seq$((Iterator)this);
        }

        public abstract T entry(int var1);

        public boolean hasNext() {
            while (this.idx < GenericHashMap.this.table().length && GenericHashMap.this.table()[this.idx] == null) {
                this.idx += 2;
            }
            return this.idx < GenericHashMap.this.table().length;
        }

        public T next() {
            T t;
            Predef$.MODULE$.require(this.hasNext());
            try {
                t = this.entry(this.idx);
            }
            finally {
                this.idx += 2;
            }
            return t;
        }

        public final /* synthetic */ GenericHashMap dotty$tools$dotc$util$GenericHashMap$EntryIterator$$$outer() {
            return GenericHashMap.this;
        }
    }
}

