/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;

final class DTV {
    private DTVImpl impl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;

    DTV() {
    }

    int setFromTDS(TypeInfo typeInfo, int n, byte[] byArray, boolean bl) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.setFromTDS(this, typeInfo, n, byArray, bl);
    }

    void setValue(int n, Object object, Object object2) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setValue(this, n, object, object2);
    }

    Object getSetterArgs() {
        return this.impl.getSetterArgs();
    }

    boolean isNull() {
        return null == this.impl || this.impl.isNull();
    }

    final int getJdbcType() throws SQLServerException {
        return this.impl.getJdbcType();
    }

    Object getValue(int n, int n2, Object object) throws SQLServerException {
        return this.impl.getValue(this, n, true, n2, object);
    }

    byte getByte() throws SQLServerException {
        return this.impl.getByte(this);
    }

    int getInt() throws SQLServerException {
        Object object = this.impl.getValue(this, 4, false, 0, null);
        return null != object ? ((Integer)object).intValue() : this.impl.getInt();
    }

    short getShort() throws SQLServerException {
        Object object = this.impl.getValue(this, 5, false, 0, null);
        return null != object ? ((Short)object).shortValue() : this.impl.getShort();
    }

    void setImpl(DTVImpl dTVImpl) {
        this.impl = dTVImpl;
    }

    static void executeOp(DTV dTV, DTVExecuteOp dTVExecuteOp, Object object, int n) throws SQLServerException {
        if ((class$java$lang$String == null ? (class$java$lang$String = DTV.class$("java.lang.String")) : class$java$lang$String).isInstance(object) || null == object && (1 == n || 12 == n || -1 == n)) {
            dTVExecuteOp.execute((String)object, n);
        } else if ((class$java$sql$Clob == null ? (class$java$sql$Clob = DTV.class$("java.sql.Clob")) : class$java$sql$Clob).isInstance(object) || null == object && 2005 == n) {
            dTVExecuteOp.execute((Clob)object, n);
        } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = DTV.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(object) || null == object && 4 == n) {
            dTVExecuteOp.execute((Integer)object, n);
        } else if ((class$java$sql$Date == null ? (class$java$sql$Date = DTV.class$("java.sql.Date")) : class$java$sql$Date).isInstance(object) || null == object && 91 == n) {
            dTVExecuteOp.execute((Date)object, dTV, n);
        } else if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DTV.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isInstance(object) || null == object && 93 == n) {
            dTVExecuteOp.execute((Timestamp)object, dTV, n);
        } else if ((class$java$lang$Float == null ? (class$java$lang$Float = DTV.class$("java.lang.Float")) : class$java$lang$Float).isInstance(object) || null == object && (6 == n || 7 == n)) {
            dTVExecuteOp.execute((Float)object, n);
        } else if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DTV.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isInstance(object) || null == object && (2 == n || 3 == n)) {
            dTVExecuteOp.execute((BigDecimal)object, n);
        } else if ((array$B == null ? (array$B = DTV.class$("[B")) : array$B).isInstance(object) || null == object && (-2 == n || -3 == n || -4 == n)) {
            dTVExecuteOp.execute((byte[])object, n);
        } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = DTV.class$("java.lang.Byte")) : class$java$lang$Byte).isInstance(object) || null == object && -6 == n) {
            dTVExecuteOp.execute((Byte)object, n);
        } else if ((class$java$lang$Long == null ? (class$java$lang$Long = DTV.class$("java.lang.Long")) : class$java$lang$Long).isInstance(object) || null == object && -5 == n) {
            dTVExecuteOp.execute((Long)object, n);
        } else if ((class$java$lang$Double == null ? (class$java$lang$Double = DTV.class$("java.lang.Double")) : class$java$lang$Double).isInstance(object) || null == object && 8 == n) {
            dTVExecuteOp.execute((Double)object, n);
        } else if ((class$java$lang$Short == null ? (class$java$lang$Short = DTV.class$("java.lang.Short")) : class$java$lang$Short).isInstance(object) || null == object && 5 == n) {
            dTVExecuteOp.execute((Short)object, n);
        } else if ((class$java$sql$Time == null ? (class$java$sql$Time = DTV.class$("java.sql.Time")) : class$java$sql$Time).isInstance(object) || null == object && 92 == n) {
            dTVExecuteOp.execute((Time)object, dTV, n);
        } else if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = DTV.class$("java.lang.Boolean")) : class$java$lang$Boolean).isInstance(object) || null == object && (-7 == n || 16 == n)) {
            dTVExecuteOp.execute((Boolean)object, n);
        } else if ((class$java$sql$Blob == null ? (class$java$sql$Blob = DTV.class$("java.sql.Blob")) : class$java$sql$Blob).isInstance(object) || null == object && 2004 == n) {
            dTVExecuteOp.execute((Blob)object, n);
        } else if ((class$java$io$InputStream == null ? (class$java$io$InputStream = DTV.class$("java.io.InputStream")) : class$java$io$InputStream).isInstance(object)) {
            dTVExecuteOp.execute((InputStream)object, dTV, n);
        } else if ((class$java$io$Reader == null ? (class$java$io$Reader = DTV.class$("java.io.Reader")) : class$java$io$Reader).isInstance(object) || null == object && -1 == n) {
            dTVExecuteOp.execute((Reader)object, dTV, n);
        } else {
            dTVExecuteOp.executeDefault(object, n);
        }
    }

    void sendByRPC(String string, int n, int n2, int n3, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n4) throws SQLServerException {
        SendByRPCOp sendByRPCOp = new SendByRPCOp(string, n2, n3, bl, tDSWriter, sQLServerConnection, n4);
        DTV.executeOp(this, sendByRPCOp, this.getValue(n, n3, null), n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class SendByRPCOp
    extends DTVExecuteOp {
        private final String name;
        private final int nativeType;
        private final int outScale;
        private final boolean isOutParam;
        private final TDSWriter tdsWriter;
        private final SQLServerConnection conn;
        private final int index;

        SendByRPCOp(String string, int n, int n2, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n3) {
            this.name = string;
            this.nativeType = n;
            this.outScale = n2;
            this.isOutParam = bl;
            this.tdsWriter = tDSWriter;
            this.index = n3;
            this.conn = sQLServerConnection;
        }

        void sendTextValue(String string, int n) throws SQLServerException {
            if (173 == this.nativeType || 165 == this.nativeType || 34 == this.nativeType || 240 == this.nativeType || 0 == this.nativeType && (-2 == n || -3 == n || -4 == n)) {
                this.tdsWriter.writeRPCByteArray(this.name, null == string ? null : ParameterUtils.HexToBin(string), this.isOutParam, -2);
            } else {
                int n2 = 4000;
                if (!this.conn.sendStringParametersAsUnicode()) {
                    n2 *= 2;
                }
                if (string != null && string.length() > n2) {
                    this.tdsWriter.writeRPCLongStringUnicode(this.name, string, this.isOutParam);
                } else if (this.conn.sendStringParametersAsUnicode()) {
                    this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, n);
                } else {
                    this.tdsWriter.writeRPCStringNonUnicode(this.name, string, this.isOutParam, n);
                }
            }
        }

        void execute(String string, int n) throws SQLServerException {
            this.sendTextValue(string, n);
        }

        void execute(Clob clob, int n) throws SQLServerException {
            String string = null;
            if (null != clob) {
                try {
                    string = clob.getSubString(1L, (int)clob.length());
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
                }
            }
            this.sendTextValue(string, n);
        }

        void execute(Byte by, int n) throws SQLServerException {
            if (null != by && (10 == this.nativeType || -6 == n)) {
                Short s = new Short((short)(by.intValue() & 0xFF));
                this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
                return;
            }
            this.tdsWriter.writeRPCByte(this.name, by, this.isOutParam);
        }

        void execute(Integer n, int n2) throws SQLServerException {
            this.tdsWriter.writeRPCInt(this.name, n, this.isOutParam);
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.sendTextValue(null == time ? null : time.toString(), 1);
            } else if (93 == n || 92 == n || 91 == n) {
                Calendar calendar = null;
                if (null != time) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    if (91 == n) {
                        calendar.clear();
                    } else {
                        calendar.setTimeInMillis(time.getTime());
                        calendar.set(1970, 0, 1);
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.sendTextValue(time.toString(), n);
            }
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.sendTextValue(null == date ? null : date.toString(), 1);
            } else if (93 == n || 92 == n || 91 == n) {
                Calendar calendar = null;
                if (null != date) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    if (92 == n) {
                        calendar.clear();
                    } else {
                        calendar.setTimeInMillis(date.getTime());
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.sendTextValue(date.toString(), n);
            }
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            if (this.nativeType != 0 && !DataTypes.isTemporal(this.nativeType)) {
                this.sendTextValue(null == timestamp ? null : timestamp.toString(), 1);
            } else if (93 == n || 92 == n || 91 == n) {
                Calendar calendar = null;
                if (null != timestamp) {
                    try {
                        calendar = (Calendar)dTV.getSetterArgs();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (null == calendar) {
                        calendar = Calendar.getInstance(Locale.US);
                    }
                    calendar.setTimeInMillis(timestamp.getTime());
                    calendar.set(14, timestamp.getNanos() / 1000000);
                    switch (n) {
                        case 93: {
                            break;
                        }
                        case 91: {
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                            calendar.set(14, 0);
                            break;
                        }
                        case 92: {
                            calendar.set(1970, 0, 1);
                        }
                    }
                }
                this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
            } else {
                this.sendTextValue(timestamp.toString(), n);
            }
        }

        void execute(Float f, int n) throws SQLServerException {
            if (7 == n) {
                this.tdsWriter.writeRPCReal(this.name, f, this.isOutParam);
            } else {
                Double d = null == f ? null : new Double(f.floatValue());
                this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
            }
        }

        void execute(Double d, int n) throws SQLServerException {
            this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            if (DDC.exceedsMaxRPCDecimalPrecisionOrScale(bigDecimal)) {
                String string = bigDecimal.toString();
                this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, 1);
            } else {
                this.tdsWriter.writeRPCBigDecimal(this.name, bigDecimal, this.outScale, this.isOutParam);
            }
        }

        void execute(Long l, int n) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, l, this.isOutParam);
        }

        void execute(Short s, int n) throws SQLServerException {
            this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            this.tdsWriter.writeRPCBit(this.name, bl, this.isOutParam);
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            this.tdsWriter.writeRPCByteArray(this.name, byArray, this.isOutParam, n);
        }

        void execute(Blob blob, int n) throws SQLServerException {
            long l = 0L;
            InputStream inputStream = null;
            if (null != blob) {
                try {
                    l = blob.length();
                    inputStream = blob.getBinaryStream();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
                }
            }
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, new InputStreamArgs(1, l, 0), this.isOutParam);
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            InputStreamArgs inputStreamArgs = null;
            try {
                inputStreamArgs = (InputStreamArgs)dTV.getSetterArgs();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (null == inputStreamArgs) {
                inputStreamArgs = new InputStreamArgs(-2 == n ? 1 : 3, -1L, 0);
            }
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, inputStreamArgs, this.isOutParam);
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            boolean bl = this.conn.getDbCom().getTDSVersion().isYukonOrLater();
            boolean bl2 = this.conn.sendStringParametersAsUnicode();
            int n2 = -1;
            if (null == reader) {
                n2 = 0;
            } else {
                try {
                    CharacterStreamSetterArgs characterStreamSetterArgs = (CharacterStreamSetterArgs)dTV.getSetterArgs();
                    if (null != characterStreamSetterArgs) {
                        n2 = characterStreamSetterArgs.length;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (173 == this.nativeType || 165 == this.nativeType || 34 == this.nativeType || 0 == this.nativeType && (-2 == n || -3 == n || -4 == n)) {
                this.tdsWriter.writeRPCByteArray(this.name, null == reader ? null : ParameterUtils.HexToBin(DDC.convertReaderToString(reader, n2)), this.isOutParam, -2);
                return;
            }
            if (null != reader && !bl && !bl2) {
                int n3 = 4000;
                if (!bl2) {
                    n3 *= 2;
                }
                if (n2 < n3) {
                    this.tdsWriter.writeRPCStringNonUnicode(this.name, DDC.convertReaderToString(reader, n2), this.isOutParam, n);
                    return;
                }
            }
            this.tdsWriter.writeRPCReader(this.name, reader, n2, bl, this.isOutParam);
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_noRPCMappingForTypeColumn"));
            Object[] objectArray = new Object[]{new Integer(n), new Integer(this.index + 1)};
            SQLServerException.makeFromDriverError(this.conn, null, messageFormat.format(objectArray), null, true);
        }
    }
}

