/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.dialog.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public final class NativeDemandDialog
extends FreeColConfirmDialog {
    public NativeDemandDialog(FreeColClient freeColClient, JFrame frame, Unit unit, Colony colony, GoodsType type, int amount) {
        super(freeColClient, frame);
        String no;
        String yes;
        Object template;
        String nation = Messages.message(unit.getOwner().getNationLabel());
        if (type == null) {
            template = ((StringTemplate)((StringTemplate)StringTemplate.template("indianDemand.gold.text").addName("%nation%", nation)).addName("%colony%", colony.getName())).addAmount("%amount%", amount);
            yes = "accept";
            no = "indianDemand.gold.no";
        } else if (type.isFoodType()) {
            template = ((StringTemplate)((StringTemplate)StringTemplate.template("indianDemand.food.text").addName("%nation%", nation)).addName("%colony%", colony.getName())).addAmount("%amount%", amount);
            yes = "indianDemand.food.yes";
            no = "indianDemand.food.no";
        } else {
            template = ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("indianDemand.other.text").addName("%nation%", nation)).addName("%colony%", colony.getName())).addAmount("%amount%", amount)).addNamed("%goods%", type);
            yes = "accept";
            no = "indianDemand.other.no";
        }
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, fill", "[400, align center]"));
        Object t = StringTemplate.template("nativeDemandDialog.name").addName("%colony%", colony.getName());
        JLabel header = Utility.localizedHeaderLabel(t, 10, Utility.FONTSPEC_TITLE);
        panel.add(header);
        JTextArea text = Utility.localizedTextArea(template);
        panel.add(text);
        ImageLibrary lib = this.getImageLibrary();
        ImageIcon icon = new ImageIcon(lib.getSmallSettlementImage(colony));
        this.initializeConfirmDialog(frame, true, panel, icon, yes, no);
    }
}

