/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.openstreetmap.josm.tools.template_engine.StaticText;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public final class CompoundTemplateEntry
implements TemplateEntry {
    private final TemplateEntry[] entries;

    public static TemplateEntry fromArray(TemplateEntry ... entries) {
        if (entries.length == 0) {
            return new StaticText("");
        }
        if (entries.length == 1) {
            return entries[0];
        }
        return new CompoundTemplateEntry(entries);
    }

    private CompoundTemplateEntry(TemplateEntry ... entries) {
        this.entries = entries;
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        for (TemplateEntry te : this.entries) {
            te.appendText(result, dataProvider);
        }
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        return Arrays.stream(this.entries).allMatch(te -> te.isValid(dataProvider));
    }

    public String toString() {
        return Arrays.stream(this.entries).map(String::valueOf).collect(Collectors.joining());
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.entries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundTemplateEntry other = (CompoundTemplateEntry)obj;
        return Arrays.equals(this.entries, other.entries);
    }
}

