/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStretch;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class FontStretchResolveHandler
extends ConstantsResolveHandler {
    public FontStretchResolveHandler() {
        this.addNormalizeValue(FontStretch.CONDENSED);
        this.addNormalizeValue(FontStretch.EXPANDED);
        this.addNormalizeValue(FontStretch.EXTRA_CONDENSED);
        this.addNormalizeValue(FontStretch.EXTRA_EXPANDED);
        this.addNormalizeValue(FontStretch.NORMAL);
        this.addNormalizeValue(FontStretch.SEMI_CONDENSED);
        this.addNormalizeValue(FontStretch.SEMI_EXPANDED);
        this.addNormalizeValue(FontStretch.ULTRA_CONDENSED);
        this.addNormalizeValue(FontStretch.ULTRA_EXPANDED);
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSConstant cSSConstant;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (FontStretch.WIDER.equals(cSSValue)) {
            CSSConstant cSSConstant2 = this.queryParent(layoutElement.getParent());
            cSSConstant = FontStretch.getByOrder(FontStretch.getOrder(cSSConstant2) + 1);
        } else if (FontStretch.NARROWER.equals(cSSValue)) {
            CSSConstant cSSConstant3 = this.queryParent(layoutElement.getParent());
            cSSConstant = FontStretch.getByOrder(FontStretch.getOrder(cSSConstant3) - 1);
        } else {
            CSSConstant cSSConstant4;
            cSSConstant = cSSValue instanceof CSSConstant ? ((cSSConstant4 = (CSSConstant)this.lookupValue((CSSConstant)cSSValue)) != null ? cSSConstant4 : FontStretch.NORMAL) : FontStretch.NORMAL;
        }
        layoutContext.setValue(styleKey, cSSConstant);
    }

    private CSSConstant queryParent(LayoutElement layoutElement) {
        if (layoutElement == null) {
            return FontStretch.NORMAL;
        }
        CSSValue cSSValue = layoutElement.getLayoutContext().getValue(FontStyleKeys.FONT_STRETCH);
        if (cSSValue == null) {
            return FontStretch.NORMAL;
        }
        return FontStretch.getByOrder(FontStretch.getOrder(cSSValue));
    }
}

