/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.health.Diagnosis;
import org.logstash.health.Impact;
import org.logstash.health.Indicator;
import org.logstash.health.Probe;
import org.logstash.health.ReportContext;
import org.logstash.health.Status;

public class ProbeIndicator<OBSERVATION extends Observation>
implements Indicator<Report<OBSERVATION>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String subject;
    private final Observer<OBSERVATION> observer;
    private final Map<String, Probe<OBSERVATION>> probes = new ConcurrentHashMap<String, Probe<OBSERVATION>>();

    public ProbeIndicator(String subject, Observer<OBSERVATION> observer, Map<String, Probe<OBSERVATION>> probes) {
        this(subject, observer);
        probes.forEach(this::attachProbe);
    }

    public ProbeIndicator(String subject, Observer<OBSERVATION> observer) {
        this.subject = subject;
        this.observer = observer;
    }

    public final void attachProbe(String name, Probe<OBSERVATION> probeToAttach) {
        Probe<OBSERVATION> existing = this.probes.putIfAbsent(name, probeToAttach);
        if (Objects.nonNull(existing) && !Objects.equals(existing, probeToAttach)) {
            throw new IllegalArgumentException("Cannot attach probe " + name + " because a different one of the same name is already attached.");
        }
    }

    public final void detachProbe(String name, Probe<OBSERVATION> probeToDetach) {
        Probe remaining = this.probes.computeIfPresent(name, (key, existing) -> Objects.equals(probeToDetach, existing) ? null : existing);
        if (Objects.nonNull(remaining)) {
            throw new IllegalArgumentException("Cannot detach probe " + name + " because a different one of the same name is attached.");
        }
    }

    public final void detachProbe(String name) {
        this.probes.remove(name);
    }

    Probe<OBSERVATION> getProbe(String name) {
        return this.probes.get(name);
    }

    @Override
    public Report<OBSERVATION> report(ReportContext reportContext) {
        LOGGER.debug("report starting with {} probes {}", this.probes.keySet(), (Object)reportContext);
        Observation observation = (Observation)this.observer.get();
        Status.Holder combinedStatus = new Status.Holder();
        ArrayList<Diagnosis> diagnoses = new ArrayList<Diagnosis>();
        ArrayList<Impact> impacts = new ArrayList<Impact>();
        HashSet distinctImpactAreas = new HashSet();
        for (Map.Entry<String, Probe<OBSERVATION>> probeEntry : this.probes.entrySet()) {
            String probeName = probeEntry.getKey();
            Probe.Analysis probeAnalysis = probeEntry.getValue().analyze(observation);
            LOGGER.trace("probe {}: {}", (Object)probeName, (Object)probeAnalysis);
            if (reportContext.isMuted(probeName)) {
                LOGGER.trace("probe {} is muted", (Object)probeName);
                continue;
            }
            combinedStatus.reduce(probeAnalysis.status);
            Optional.ofNullable(probeAnalysis.diagnosis).ifPresent(diagnoses::add);
            Optional.ofNullable(probeAnalysis.impact).filter(impacts::add).map(impact -> impact.impactAreas).ifPresent(distinctImpactAreas::addAll);
        }
        Status status = combinedStatus.value();
        StringBuilder symptomBuilder = new StringBuilder();
        symptomBuilder.append(String.format("The %s is %s", this.subject, status.descriptiveValue()));
        if (distinctImpactAreas.size() + diagnoses.size() > 0) {
            symptomBuilder.append("; ").append(String.format(distinctImpactAreas.size() == 1 ? "%s area is impacted" : "%s areas are impacted", distinctImpactAreas.size())).append(" and ").append(String.format(diagnoses.size() == 1 ? "%s diagnosis is available" : "%s diagnoses are available", diagnoses.size()));
        }
        String symptom = symptomBuilder.toString();
        return new Report<Observation>(status, observation, symptom, diagnoses, impacts);
    }

    public String toString() {
        return "ProbeIndicator{observer=" + String.valueOf(this.observer) + ", probes=" + String.valueOf(this.probes) + "}";
    }

    @FunctionalInterface
    public static interface Observer<OBSERVATION extends Observation>
    extends Supplier<OBSERVATION> {
    }

    public static interface Observation {
    }

    @JsonSerialize(using=JsonSerializer.class)
    public static class Report<DETAILS>
    implements Indicator.Report {
        private final Status status;
        private final DETAILS details;
        private final String symptom;
        private final List<Diagnosis> diagnosis;
        private final List<Impact> impacts;

        public Report(Status status, DETAILS details, String symptom, List<Diagnosis> diagnosis, List<Impact> impacts) {
            this.status = status;
            this.details = details;
            this.symptom = symptom;
            this.diagnosis = List.copyOf(diagnosis);
            this.impacts = List.copyOf(impacts);
        }

        @Override
        public Status status() {
            return this.status;
        }

        public DETAILS details() {
            return this.details;
        }

        public String symptom() {
            return this.symptom;
        }

        public List<Diagnosis> diagnosis() {
            return this.diagnosis;
        }

        public List<Impact> impacts() {
            return this.impacts;
        }

        public static class JsonSerializer
        extends com.fasterxml.jackson.databind.JsonSerializer<Report<?>> {
            public void serialize(Report<?> report, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("status", (Object)report.status);
                jsonGenerator.writeStringField("symptom", report.symptom);
                if (Objects.nonNull(report.diagnosis) && !report.diagnosis.isEmpty()) {
                    jsonGenerator.writeObjectField("diagnosis", report.diagnosis);
                }
                if (Objects.nonNull(report.impacts) && !report.impacts.isEmpty()) {
                    jsonGenerator.writeObjectField("impacts", report.impacts);
                }
                jsonGenerator.writeObjectField("details", report.details);
                jsonGenerator.writeEndObject();
            }
        }
    }
}

