/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class GenerationClauseNode
extends ValueNode {
    private ValueNode _generationExpression;
    private String _expressionText;
    private ValueNode _boundExpression;
    private ProviderList _apl;

    GenerationClauseNode(ValueNode generationExpression, String expressionText, ContextManager cm) {
        super(cm);
        this._generationExpression = generationExpression;
        this._expressionText = expressionText;
    }

    public String getExpressionText() {
        return this._expressionText;
    }

    void setAuxiliaryProviderList(ProviderList apl) {
        this._apl = apl;
    }

    ProviderList getAuxiliaryProviderList() {
        return this._apl;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this._boundExpression = this._generationExpression.bindExpression(fromList, subqueryList, aggregates);
        return this._boundExpression;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException((String)"XSCH8.S", (Object[])new Object[0]);
    }

    @Override
    boolean isEquivalent(ValueNode other) throws StandardException {
        if (!this.isSameNodeKind(other)) {
            return false;
        }
        GenerationClauseNode that = (GenerationClauseNode)other;
        return this._generationExpression.isEquivalent(that._generationExpression);
    }

    public List<ColumnReference> findReferencedColumns() throws StandardException {
        CollectNodesVisitor<ColumnReference> visitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this._generationExpression.accept(visitor);
        return visitor.getList();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this._generationExpression != null) {
            this._generationExpression = (ValueNode)this._generationExpression.accept(v);
        }
        if (this._boundExpression != null) {
            this._boundExpression = (ValueNode)this._boundExpression.accept(v);
        }
    }

    @Override
    public String toString() {
        return "expressionText: GENERATED ALWAYS AS ( " + this._expressionText + " )\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "generationExpression: ");
        this._generationExpression.treePrint(depth + 1);
        if (this._boundExpression != null) {
            this.printLabel(depth, "boundExpression. ");
            this._boundExpression.treePrint(depth + 1);
        }
    }
}

