/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.URIUtil;

public final class RedirectUtil {
    public static String toRedirectURL(HttpServletRequest request, String location) {
        if (!URIUtil.hasScheme((String)location)) {
            StringBuilder url = new StringBuilder(128);
            URIUtil.appendSchemeHostPort((StringBuilder)url, (String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort());
            if (location.startsWith("/")) {
                location = URIUtil.canonicalURI((String)location);
            } else {
                String path = request.getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath((String)path);
                location = URIUtil.canonicalURI((String)URIUtil.addEncodedPaths((String)parent, (String)location));
                if (location != null && !location.startsWith("/")) {
                    url.append('/');
                }
            }
            if (location == null) {
                throw new IllegalStateException("redirect path cannot be above root");
            }
            url.append(location);
            location = url.toString();
        }
        return location;
    }
}

