/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;

public class ModelUtil {
    public static final boolean ANDROID_RUNTIME;
    public static final boolean ANDROID_EMULATOR;

    public static boolean isStringConvertibleType(Set<Class> stringConvertibleTypes, Class clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        for (Class toStringOutputType : stringConvertibleTypes) {
            if (!toStringOutputType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidUDAName(String name) {
        if (ANDROID_RUNTIME) {
            return name != null && !name.isEmpty();
        }
        return name != null && !name.isEmpty() && !name.toLowerCase(Locale.ENGLISH).startsWith("xml") && name.matches("[a-zA-Z0-9^-_\\p{L}\\p{N}]{1}[a-zA-Z0-9^-_\\.\\\\p{L}\\\\p{N}\\p{Mc}\\p{Sk}]*");
    }

    public static InetAddress getInetAddressByName(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toCommaSeparatedList(Object[] o) {
        return ModelUtil.toCommaSeparatedList(o, true, false);
    }

    public static String toCommaSeparatedList(Object[] o, boolean escapeCommas, boolean escapeDoubleQuotes) {
        if (o == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : o) {
            String objString = obj.toString();
            objString = objString.replaceAll("\\\\", "\\\\\\\\");
            if (escapeCommas) {
                objString = objString.replaceAll(",", "\\\\,");
            }
            if (escapeDoubleQuotes) {
                objString = objString.replaceAll("\"", "\\\"");
            }
            sb.append(objString).append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String[] fromCommaSeparatedList(String s) {
        return ModelUtil.fromCommaSeparatedList(s, true);
    }

    public static String[] fromCommaSeparatedList(String s, boolean unescapeCommas) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String QUOTED_COMMA_PLACEHOLDER = "XXX1122334455XXX";
        if (unescapeCommas) {
            s = s.replaceAll("\\\\,", "XXX1122334455XXX");
        }
        String[] split = s.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].replaceAll("XXX1122334455XXX", ",");
            split[i] = split[i].replaceAll("\\\\\\\\", "\\\\");
        }
        return split;
    }

    public static String toTimeString(long seconds) {
        long hours = seconds / 3600L;
        long remainder = seconds % 3600L;
        long minutes = remainder / 60L;
        long secs = remainder % 60L;
        return (hours < 10L ? "0" : "") + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (secs < 10L ? "0" : "") + secs;
    }

    public static long fromTimeString(String s) {
        String[] split;
        if (s.lastIndexOf(".") != -1) {
            s = s.substring(0, s.lastIndexOf("."));
        }
        if ((split = s.split(":")).length != 3) {
            throw new IllegalArgumentException("Can't parse time string: " + s);
        }
        return Long.parseLong(split[0]) * 3600L + Long.parseLong(split[1]) * 60L + Long.parseLong(split[2]);
    }

    public static String commaToNewline(String s) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        for (String splitString : split = s.split(",")) {
            sb.append(splitString).append(",").append("\n");
        }
        if (sb.length() > 2) {
            sb.deleteCharAt(sb.length() - 2);
        }
        return sb.toString();
    }

    public static String getLocalHostName(boolean includeDomain) {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            return includeDomain ? hostname : (hostname.contains(".") ? hostname.substring(0, hostname.indexOf(".")) : hostname);
        }
        catch (Exception e) {
            return "UNKNOWN HOST";
        }
    }

    public static byte[] getFirstNetworkInterfaceHardwareAddress() {
        try {
            Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(interfaceEnumeration)) {
                if (iface.isLoopback() || !iface.isUp() || iface.getHardwareAddress() == null) continue;
                return iface.getHardwareAddress();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not discover first network interface hardware address");
        }
        throw new RuntimeException("Could not discover first network interface hardware address");
    }

    static {
        Class<?> androidBuild2;
        boolean foundAndroid = false;
        try {
            androidBuild2 = Thread.currentThread().getContextClassLoader().loadClass("android.os.Build");
            foundAndroid = androidBuild2.getField("ID").get(null) != null;
        }
        catch (Exception androidBuild2) {
            // empty catch block
        }
        ANDROID_RUNTIME = foundAndroid;
        boolean foundEmulator = false;
        try {
            androidBuild2 = Thread.currentThread().getContextClassLoader().loadClass("android.os.Build");
            String product = (String)androidBuild2.getField("PRODUCT").get(null);
            if ("google_sdk".equals(product) || "sdk".equals(product)) {
                foundEmulator = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ANDROID_EMULATOR = foundEmulator;
    }
}

