"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detectIndexType = detectIndexType;
var _lodash = require("lodash");
var _index_cache = require("./index_cache");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const INDEX_TYPE_DETECT_AGENT_CONFIG_ID = 'os_index_type_detect';
async function searchQuery(client, path, method, query) {
  return await client.request({
    path,
    method,
    body: query
  });
}
async function searchSampleData(client, indexName) {
  const query = {
    size: 5,
    query: {
      match_all: {}
    }
  };
  const response = await searchQuery(client, `/${encodeURIComponent(indexName)}/_search`, 'POST', query);
  const sourceArray = response.body.hits.hits.map(hit => hit._source);
  return sourceArray;
}
async function searchIndexMapping(client, indexName) {
  const response = await searchQuery(client, `/${encodeURIComponent(indexName)}/_mapping`, 'GET', undefined);
  return response.body;
}
async function detectIndexType(client, assistantClient, indexName, dataSourceId) {
  const indexCache = (0, _index_cache.getIndexCache)(indexName, dataSourceId ? dataSourceId : '');
  if (indexCache) {
    return indexCache.isLogRelated;
  }
  try {
    const indexMapping = (0, _lodash.escape)(JSON.stringify(await searchIndexMapping(client, indexName)));
    const sampleData = (0, _lodash.escape)(JSON.stringify(await searchSampleData(client, indexName)));
    const response = await assistantClient.executeAgentByConfigName(INDEX_TYPE_DETECT_AGENT_CONFIG_ID, {
      sampleData,
      schema: indexMapping
    });
    const detectResult = JSON.parse(response.body.inference_results[0].output[0].result);
    if (detectResult) {
      (0, _index_cache.setIndexCache)(new _index_cache.IndexCacheData(detectResult.isRelated, detectResult.reason), indexName, dataSourceId ? dataSourceId : '');
      return detectResult.isRelated;
    }
    return false;
  } catch (error) {
    console.error('Error detecting index type:', error.body || error.message);
    // Can not detect index type and return default as is not log related
    return false;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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