/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 0ul) => u64vec3(1333333333333333259ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 1ul) => u64vec3(2666666666666666518ul, 170ul, 188ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 2ul) => u64vec3(5333333333333333036ul, 340ul, 376ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 5ul) => u64vec3(5773178519247561056ul, 2720ul, 3008ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 25ul) => u64vec3(3776561488156688384ul, 2852126720ul, 3154116608ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 31ul) => u64vec3(1892262283803885568ul, 182536110080ul, 201863462912ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 32ul) => u64vec3(3784524567607771136ul, 365072220160ul, 403726925824ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 47ul) => u64vec3(12287367895838621696ul, 11962686510202880ul, 13229323905400832ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 63ul) => u64vec3(9223372036854775808ul, 9223372036854775808ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) << 0ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) << 1ul) => u64vec3(334ul, 132ul, 374ul)
 * (u64vec3(167ul, 66ul, 187ul) << 2ul) => u64vec3(668ul, 264ul, 748ul)
 * (u64vec3(167ul, 66ul, 187ul) << 5ul) => u64vec3(5344ul, 2112ul, 5984ul)
 * (u64vec3(167ul, 66ul, 187ul) << 25ul) => u64vec3(5603590144ul, 2214592512ul, 6274678784ul)
 * (u64vec3(167ul, 66ul, 187ul) << 31ul) => u64vec3(358629769216ul, 141733920768ul, 401579442176ul)
 * (u64vec3(167ul, 66ul, 187ul) << 32ul) => u64vec3(717259538432ul, 283467841536ul, 803158884352ul)
 * (u64vec3(167ul, 66ul, 187ul) << 47ul) => u64vec3(23503160555339776ul, 9288674231451648ul, 26317910322446336ul)
 * (u64vec3(167ul, 66ul, 187ul) << 63ul) => u64vec3(9223372036854775808ul, 0ul, 9223372036854775808ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 0ul), u64vec3(1333333333333333259ul, 85ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 1ul), u64vec3(2666666666666666518ul, 170ul, 188ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 2ul), u64vec3(5333333333333333036ul, 340ul, 376ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 5ul), u64vec3(5773178519247561056ul, 2720ul, 3008ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 25ul), u64vec3(3776561488156688384ul, 2852126720ul, 3154116608ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 31ul), u64vec3(1892262283803885568ul, 182536110080ul, 201863462912ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 32ul), u64vec3(3784524567607771136ul, 365072220160ul, 403726925824ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 47ul), u64vec3(12287367895838621696ul, 11962686510202880ul, 13229323905400832ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 63ul), u64vec3(9223372036854775808ul, 9223372036854775808ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 0ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 1ul), u64vec3(334ul, 132ul, 374ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 2ul), u64vec3(668ul, 264ul, 748ul))) ? 1 : -1] array11;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 5ul), u64vec3(5344ul, 2112ul, 5984ul))) ? 1 : -1] array12;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 25ul), u64vec3(5603590144ul, 2214592512ul, 6274678784ul))) ? 1 : -1] array13;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 31ul), u64vec3(358629769216ul, 141733920768ul, 401579442176ul))) ? 1 : -1] array14;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 32ul), u64vec3(717259538432ul, 283467841536ul, 803158884352ul))) ? 1 : -1] array15;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 47ul), u64vec3(23503160555339776ul, 9288674231451648ul, 26317910322446336ul))) ? 1 : -1] array16;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 63ul), u64vec3(9223372036854775808ul, 0ul, 9223372036854775808ul))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
