/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)) => bvec4(true, false, false, false)
 * equal(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)) => bvec4(false, false, false, false)
 * equal(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)) => bvec4(true, false, false, false)
 * equal(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)) => bvec4(false, false, false, false)
 * equal(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)) => bvec4(true, false, false, false)
 * equal(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)) => bvec4(false, false, false, false)
 * equal(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)) => bvec4(true, false, false, false)
 * equal(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)) => bvec4(false, false, false, false)
 * equal(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)) => bvec4(true, false, false, false)
 * equal(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)) => bvec4(false, false, false, false)
 * equal(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)) => bvec4(true, false, false, false)
 * equal(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)) => bvec4(false, false, false, false)
 * equal(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)) => bvec4(true, true, false, false)
 */
#version 120

void main()
{
  float[equal(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0))[0] == true && equal(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0))[1] == false && equal(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0))[2] == false && equal(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0))[3] == false ? 1 : -1] array0;
  float[equal(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5))[0] == false && equal(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5))[1] == false && equal(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5))[2] == false && equal(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5))[3] == false ? 1 : -1] array1;
  float[equal(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1))[0] == true && equal(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1))[1] == false && equal(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1))[2] == false && equal(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1))[3] == false ? 1 : -1] array2;
  float[equal(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2))[0] == false && equal(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2))[1] == false && equal(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2))[2] == false && equal(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2))[3] == false ? 1 : -1] array3;
  float[equal(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2))[0] == true && equal(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2))[1] == false && equal(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2))[2] == false && equal(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2))[3] == false ? 1 : -1] array4;
  float[equal(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1))[0] == false && equal(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1))[1] == false && equal(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1))[2] == false && equal(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1))[3] == false ? 1 : -1] array5;
  float[equal(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5))[0] == true && equal(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5))[1] == false && equal(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5))[2] == false && equal(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5))[3] == false ? 1 : -1] array6;
  float[equal(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0))[0] == false && equal(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0))[1] == false && equal(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0))[2] == false && equal(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0))[3] == false ? 1 : -1] array7;
  float[equal(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5))[0] == true && equal(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5))[1] == false && equal(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5))[2] == false && equal(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5))[3] == false ? 1 : -1] array8;
  float[equal(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1))[0] == false && equal(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1))[1] == false && equal(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1))[2] == false && equal(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1))[3] == false ? 1 : -1] array9;
  float[equal(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2))[0] == true && equal(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2))[1] == false && equal(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2))[2] == false && equal(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2))[3] == false ? 1 : -1] array10;
  float[equal(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2))[0] == false && equal(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2))[1] == false && equal(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2))[2] == false && equal(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2))[3] == false ? 1 : -1] array11;
  float[equal(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1))[0] == true && equal(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1))[1] == true && equal(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1))[2] == false && equal(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1))[3] == false ? 1 : -1] array12;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
