/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.undo;

import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.model.NodeModel;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class NodeImplChangeAndValueSetEdit
extends AbstractUndoableEdit {
    protected NodeModel model;
    protected Node node;
    protected LinkedList previous;
    protected List previousPosition;
    protected Object oldImpl;
    protected Object newImpl;
    protected Field field;
    protected Object value;
    protected FieldContext context;
    protected Object source;

    public NodeImplChangeAndValueSetEdit(NodeModel nodeModel, Node node, LinkedList linkedList, List list, Object object, Field field, Object object2, FieldContext fieldContext, Object object3) {
        this.model = nodeModel;
        this.node = node;
        this.previous = linkedList;
        this.previousPosition = list;
        this.oldImpl = object;
        this.field = field;
        this.value = object2;
        this.context = fieldContext;
        this.source = object3;
        this.newImpl = node.getImpl();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.model.replaceImplAndSetFieldValue(this.node, this.previous, this.newImpl, this.field, this.source, this.value, this.context, 1);
        }
        catch (FieldParseException fieldParseException) {
            fieldParseException.printStackTrace();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.previousPosition != null) {
            for (Position position : this.previousPosition) {
                this.model.remove(position.child, 0);
                this.model.add(position.parent, position.child, position.index, 0);
            }
        }
        Object object = this.node.getImpl();
        this.model.replaceImpl(this.node, this.oldImpl, this.source, 1);
        this.model.getDataFactory().remove(object, this.model, false, false, true);
    }

    @Override
    public String getPresentationName() {
        return "NodeImplChangeAndValueSet";
    }

    public static class Position {
        Node parent;
        Node child;
        int index;

        public Position(Node node, Node node2, int n) {
            this.parent = node;
            this.child = node2;
            this.index = n;
        }
    }
}

