/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import jakarta.inject.Inject;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.traccar.api.security.PermissionsService;
import org.traccar.helper.model.PositionUtil;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.BaseModel;
import org.traccar.model.Geofence;
import org.traccar.model.Message;
import org.traccar.model.Position;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class CsvExportProvider {
    private final Storage storage;
    private final PermissionsService permissionsService;

    @Inject
    public CsvExportProvider(Storage storage, PermissionsService permissionsService) {
        this.storage = storage;
        this.permissionsService = permissionsService;
    }

    public void generate(OutputStream outputStream, long userId, long deviceId, long geofenceId, Date from, Date to) throws StorageException {
        Server server = this.permissionsService.getServer();
        User user = this.permissionsService.getUser(userId);
        List<Position> positions = PositionUtil.getPositions(this.storage, deviceId, from, to);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(UserUtil.getTimezone(server, user));
        Geofence geofence = geofenceId == 0L ? null : this.storage.getObject(Geofence.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", geofenceId)));
        Set<String> attributes = positions.stream().filter(position -> geofence == null || geofence.containsPosition((Position)position)).flatMap(position -> position.getAttributes().keySet().stream()).collect(Collectors.toUnmodifiableSet());
        LinkedHashMap<String, Function<Position, Object>> properties = new LinkedHashMap<String, Function<Position, Object>>();
        properties.put("id", BaseModel::getId);
        properties.put("deviceId", Message::getDeviceId);
        properties.put("protocol", Position::getProtocol);
        properties.put("serverTime", position -> dateFormat.format(position.getServerTime()));
        properties.put("deviceTime", position -> dateFormat.format(position.getDeviceTime()));
        properties.put("fixTime", position -> dateFormat.format(position.getFixTime()));
        properties.put("valid", Position::getValid);
        properties.put("latitude", Position::getLatitude);
        properties.put("longitude", Position::getLongitude);
        properties.put("altitude", Position::getAltitude);
        properties.put("speed", Position::getSpeed);
        properties.put("course", Position::getCourse);
        properties.put("address", Position::getAddress);
        properties.put("accuracy", Position::getAccuracy);
        attributes.forEach(key -> properties.put((String)key, position -> position.getAttributes().get(key)));
        try (PrintWriter writer = new PrintWriter(outputStream);){
            writer.println(String.join((CharSequence)",", properties.keySet()));
            positions.forEach(position -> writer.println(properties.values().stream().map(f -> Objects.toString(f.apply(position), "")).collect(Collectors.joining(","))));
        }
    }
}

