/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import com.thaiopensource.validate.IncorrectSchemaException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import nu.validator.servlet.CharsetEmitter;
import nu.validator.servlet.Html5FormEmitter;
import nu.validator.servlet.NsFilterEmitter;
import nu.validator.servlet.VerifierServlet;
import nu.validator.servlet.VerifierServletTransaction;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class Html5ConformanceCheckerTransaction
extends VerifierServletTransaction {
    private static final String GENERIC_FACET = (String)(VerifierServlet.GENERIC_HOST.isEmpty() ? "" : "//" + VerifierServlet.GENERIC_HOST) + VerifierServlet.GENERIC_PATH;
    private static final char[] GENERIC_UI = "More options".toCharArray();
    private static final char[] SERVICE_TITLE = (System.getProperty("nu.validator.servlet.service-name", "Validator.nu") + " (X)HTML5 Validator ").toCharArray();
    private static final char[] TECHNOLOGY_PREVIEW = "(Living Validator)".toCharArray();
    private static final char[] RESULTS_TITLE = "(X)HTML5 validation results".toCharArray();
    private static final char[] FOR = " for ".toCharArray();
    private static final String SUCCESS_HTML = "The document is valid HTML5 + ARIA + SVG 1.1 + MathML 2.0 (subject to the utter previewness of this service).";
    private static final String SUCCESS_XHTML = "The document is valid XHTML5 + ARIA + SVG 1.1 + MathML 2.0 (subject to the utter previewness of this service).";
    private static final String FAILURE_HTML = "There were errors. (Tried in the text/html mode.)";
    private static final String FAILURE_XHTML = "There were errors. (Tried in the XHTML mode.)";
    private boolean usingHtml = false;

    @Override
    protected boolean isSimple() {
        return true;
    }

    public Html5ConformanceCheckerTransaction(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    @Override
    protected String successMessage() throws SAXException {
        if (this.usingHtml) {
            return SUCCESS_HTML;
        }
        return SUCCESS_XHTML;
    }

    @Override
    protected void loadDocAndSetupParser() throws SAXException, IOException, IncorrectSchemaException, SAXNotRecognizedException, SAXNotSupportedException {
        this.setAllowGenericXml(false);
        this.setAcceptAllKnownXmlTypes(false);
        this.setAllowHtml(true);
        this.setAllowXhtml(true);
        this.loadDocumentInput();
        String type = this.documentInput.getType();
        if ("text/html".equals(type) || "text/html-sandboxed".equals(type)) {
            this.validator = this.validatorByDoctype(3);
            this.usingHtml = true;
            this.newHtmlParser();
            this.htmlParser.setDocumentModeHandler(this);
            this.htmlParser.setContentHandler(this.validator.getContentHandler());
            this.reader = this.htmlParser;
        } else {
            this.validator = this.validatorByDoctype(7);
            this.setupXmlParser();
            if (!"application/xhtml+xml".equals(type) && !"application/xml".equals(type)) {
                String message = "The preferred Content-Type for XHTML5 is application/xhtml+xml. The Content-Type was " + type + ".";
                SAXParseException spe = new SAXParseException(message, null, this.documentInput.getSystemId(), -1, -1);
                this.errorHandler.warning(spe);
            }
        }
    }

    @Override
    protected void setup() throws ServletException {
        this.schemaUrls = "";
    }

    @Override
    void emitTitle(boolean markupAllowed) throws SAXException {
        if (this.willValidate()) {
            this.emitter.characters(RESULTS_TITLE);
            if (this.document != null && this.document.length() > 0) {
                this.emitter.characters(FOR);
                this.emitter.characters(Html5ConformanceCheckerTransaction.scrub(this.shortenDataUri(this.document)));
            }
        } else {
            this.emitter.characters(SERVICE_TITLE);
            if (markupAllowed && System.getProperty("nu.validator.servlet.service-name", "Validator.nu").equals("Validator.nu")) {
                this.emitter.startElement("span");
                this.emitter.characters(TECHNOLOGY_PREVIEW);
                this.emitter.endElement("span");
            }
        }
    }

    @Override
    void emitLabel() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("id", "inputlabel");
        this.attrs.addAttribute("for", "doc");
        String allowedAddressType = System.getProperty("nu.validator.servlet.allowed-address-type", "all");
        if ("none".equals(allowedAddressType)) {
            this.attrs.addAttribute("data-allowed-address-type", allowedAddressType);
        }
        this.emitter.startElement("label", this.attrs);
        this.emitter.characters("Document URL:");
        this.emitter.endElement("label");
    }

    @Override
    protected void tryToSetupValidator() throws SAXException, IOException, IncorrectSchemaException {
    }

    @Override
    protected String failureMessage() throws SAXException {
        if (this.usingHtml) {
            return FAILURE_HTML;
        }
        return FAILURE_XHTML;
    }

    @Override
    protected void emitFormContent() throws SAXException {
        Html5FormEmitter.emit(this.contentHandler, this);
    }

    @Override
    void maybeEmitNsfilterField() throws SAXException {
        if (this.request.getParameter("nsfilter") != null) {
            NsFilterEmitter.emit(this.contentHandler, this);
        }
    }

    @Override
    void maybeEmitCharsetField() throws SAXException {
        if (this.request.getParameter("charset") != null) {
            CharsetEmitter.emit(this.contentHandler, this);
        }
    }

    @Override
    void emitOtherFacetLink() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", GENERIC_FACET);
        this.emitter.startElement("a", this.attrs);
        this.emitter.characters(GENERIC_UI);
        this.emitter.endElement("a");
    }
}

