/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.atsc;

import java.util.ArrayList;
import org.w3c.css.properties.atsc.CssOutlineColor;
import org.w3c.css.properties.atsc.CssOutlineStyle;
import org.w3c.css.properties.atsc.CssOutlineWidth;
import org.w3c.css.properties.css2.CssBorderStyle;
import org.w3c.css.properties.css2.CssBorderWidth;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssOutline
extends org.w3c.css.properties.css.CssOutline {
    public CssOutline() {
        this._color = new CssOutlineColor();
        this._style = new CssOutlineStyle();
        this._width = new CssOutlineWidth();
    }

    public CssOutline(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        ac.getFrame().addWarning("atsc", expression.toString());
        this._color = new CssOutlineColor();
        this._style = new CssOutlineStyle();
        this._width = new CssOutlineWidth();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: 
                case 6: {
                    CssExpression ex;
                    if (this._width.value == null) {
                        ex = new CssExpression();
                        ex.addValue(val);
                        this._width = new CssOutlineWidth(ac, ex, check);
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 3: {
                    CssExpression ex;
                    if (this._color.value == null) {
                        ex = new CssExpression();
                        ex.addValue(val);
                        this._color = new CssOutlineColor(ac, ex, check);
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 0: {
                    CssIdent match;
                    if (inherit.equals(val)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        this.value = inherit;
                        break;
                    }
                    CssIdent ident = (CssIdent)val;
                    if (this._style.value == null && (match = CssBorderStyle.getMatchingIdent(ident)) != null) {
                        this._style.value = match;
                        break;
                    }
                    if (this._width.value == null && (match = CssBorderWidth.getMatchingIdent(ident)) != null) {
                        this._width.value = match;
                        break;
                    }
                    if (this._color.value == null) {
                        match = CssOutlineColor.getMatchingIdent(ident);
                        if (match != null) {
                            this._color.value = match;
                            break;
                        }
                        CssExpression ex = new CssExpression();
                        ex.addValue(val);
                        this._color = new CssOutlineColor(ac, ex, check);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (expression.getCount() == 1) {
            this.value = this._width.value != null ? this._width.value : (this._style.value != null ? this._style.value : this._color.value);
        } else {
            ArrayList<CssValue> values = new ArrayList<CssValue>(4);
            if (this._width.value != null) {
                values.add(this._width.value);
            }
            if (this._style.value != null) {
                values.add(this._style.value);
            }
            if (this._color.value != null) {
                values.add(this._color.value);
            }
            this.value = new CssValueList(values);
        }
    }

    public CssOutline(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

