/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import java.io.Serializable;

public class PropertyMetadata
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final PropertyMetadata STD_REQUIRED = new PropertyMetadata(Boolean.TRUE, null);
    public static final PropertyMetadata STD_OPTIONAL = new PropertyMetadata(Boolean.FALSE, null);
    public static final PropertyMetadata STD_REQUIRED_OR_OPTIONAL = new PropertyMetadata(null, null);
    protected final Boolean _required;
    protected final String _description;

    protected PropertyMetadata(Boolean req, String desc) {
        this._required = req;
        this._description = desc;
    }

    public static PropertyMetadata construct(boolean req, String desc) {
        PropertyMetadata md;
        PropertyMetadata propertyMetadata = md = req ? STD_REQUIRED : STD_OPTIONAL;
        if (desc != null) {
            return md.withDescription(desc);
        }
        return md;
    }

    protected Object readResolve() {
        if (this._description == null) {
            if (this._required == null) {
                return STD_REQUIRED_OR_OPTIONAL;
            }
            return this._required != false ? STD_REQUIRED : STD_OPTIONAL;
        }
        return this;
    }

    public PropertyMetadata withDescription(String desc) {
        return new PropertyMetadata(this._required, desc);
    }

    public PropertyMetadata withRequired(Boolean b) {
        if (b == null ? this._required == null : this._required != null && this._required.booleanValue() == b.booleanValue()) {
            return this;
        }
        return new PropertyMetadata(b, this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isRequired() {
        return this._required != null && this._required != false;
    }

    public Boolean getRequired() {
        return this._required;
    }
}

