/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.Iterator;
import org.hibernate.PropertyValueException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public final class Nullability {
    private final SharedSessionContractImplementor session;
    private final boolean checkNullability;
    private NullabilityCheckType checkType;

    public Nullability(SharedSessionContractImplementor session, NullabilityCheckType checkType) {
        this.session = session;
        this.checkNullability = session.getFactory().getSessionFactoryOptions().isCheckNullability();
        this.checkType = checkType;
    }

    @Deprecated(forRemoval=true, since="7")
    public Nullability(SharedSessionContractImplementor session) {
        this.session = session;
        this.checkNullability = session.getFactory().getSessionFactoryOptions().isCheckNullability();
    }

    @Deprecated(forRemoval=true, since="7")
    public void checkNullability(Object[] values, EntityPersister persister, boolean isUpdate) {
        this.checkType = isUpdate ? NullabilityCheckType.UPDATE : NullabilityCheckType.CREATE;
        this.checkNullability(values, persister);
    }

    public void checkNullability(Object[] values, EntityPersister persister) {
        if (this.checkNullability) {
            boolean[] nullability = persister.getPropertyNullability();
            boolean[] checkability = this.getCheckability(persister);
            Type[] propertyTypes = persister.getPropertyTypes();
            Generator[] generators = persister.getEntityMetamodel().getGenerators();
            for (int i = 0; i < values.length; ++i) {
                if (!checkability[i] || Nullability.unfetched(values[i]) || Nullability.generated(generators[i])) continue;
                Object value = values[i];
                if (value == null) {
                    if (nullability[i]) continue;
                    throw new PropertyValueException("not-null property references a null or transient value", persister.getEntityName(), persister.getPropertyNames()[i]);
                }
                String breakProperties = this.checkSubElementsNullability(propertyTypes[i], value);
                if (breakProperties == null) continue;
                throw new PropertyValueException("not-null property references a null or transient value", persister.getEntityName(), StringHelper.qualify(persister.getPropertyNames()[i], breakProperties));
            }
        }
    }

    private boolean[] getCheckability(EntityPersister persister) {
        return this.checkType == NullabilityCheckType.CREATE ? persister.getPropertyInsertability() : persister.getPropertyUpdateability();
    }

    private static boolean unfetched(Object value) {
        return value == LazyPropertyInitializer.UNFETCHED_PROPERTY;
    }

    private static boolean generated(Generator generator) {
        return generator != null && generator.generatesSometimes();
    }

    private String checkSubElementsNullability(Type propertyType, Object value) {
        if (propertyType instanceof AnyType) {
            AnyType anyType = (AnyType)propertyType;
            return this.checkComponentNullability(value, anyType);
        }
        if (propertyType instanceof ComponentType) {
            ComponentType componentType = (ComponentType)propertyType;
            return this.checkComponentNullability(value, componentType);
        }
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            Type type = collectionType.getElementType(this.session.getFactory());
            if (type instanceof CompositeType) {
                CompositeType componentType = (CompositeType)type;
                Iterator<?> iterator = CascadingActions.getLoadedElementsIterator(collectionType, value);
                while (iterator.hasNext()) {
                    String path;
                    Object compositeElement = iterator.next();
                    if (compositeElement == null || (path = this.checkComponentNullability(compositeElement, componentType)) == null) continue;
                    return path;
                }
            }
            return null;
        }
        return null;
    }

    private String checkComponentNullability(Object composite, CompositeType compositeType) {
        if (compositeType instanceof AnyType) {
            return null;
        }
        boolean[] nullability = compositeType.getPropertyNullability();
        if (nullability != null) {
            Object[] values = compositeType.getPropertyValues(composite, this.session);
            Type[] propertyTypes = compositeType.getSubtypes();
            String[] propertyNames = compositeType.getPropertyNames();
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value == null) {
                    if (nullability[i]) continue;
                    return propertyNames[i];
                }
                String breakProperties = this.checkSubElementsNullability(propertyTypes[i], value);
                if (breakProperties == null) continue;
                return StringHelper.qualify(propertyNames[i], breakProperties);
            }
        }
        return null;
    }

    public static enum NullabilityCheckType {
        CREATE,
        UPDATE,
        DELETE;

    }
}

