/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;

public final class AlertMessage
implements DTLSMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BITS = 8;
    private final InetSocketAddress peerAddress;
    private final AlertLevel level;
    private final AlertDescription description;
    private final transient ProtocolVersion protocolVersion;

    protected AlertMessage() {
        this(null, null, null, null);
    }

    public AlertMessage(AlertLevel level, AlertDescription description, InetSocketAddress peerAddress) {
        this(level, description, null, peerAddress);
    }

    public AlertMessage(AlertLevel level, AlertDescription description, ProtocolVersion protocolVersion, InetSocketAddress peerAddress) {
        if (level == null) {
            throw new NullPointerException("Level must not be null");
        }
        if (description == null) {
            throw new NullPointerException("Description must not be null");
        }
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        if (protocolVersion != null && description != AlertDescription.PROTOCOL_VERSION) {
            throw new IllegalArgumentException("Protocol version is only supported for that specific alert!");
        }
        this.peerAddress = peerAddress;
        this.level = level;
        this.description = description;
        this.protocolVersion = protocolVersion;
    }

    @Override
    public final InetSocketAddress getPeer() {
        return this.peerAddress;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.ALERT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tAlert Protocol").append(StringUtil.lineSeparator());
        sb.append("\tLevel: ").append((Object)this.level).append(StringUtil.lineSeparator());
        sb.append("\tDescription: ").append((Object)this.description).append(StringUtil.lineSeparator());
        if (this.protocolVersion != null) {
            sb.append("\tProtocol Version: ").append(this.protocolVersion).append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write((int)this.level.getCode(), 8);
        writer.write((int)this.description.getCode(), 8);
        return writer.toByteArray();
    }

    public static AlertMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        byte levelCode = reader.readNextByte();
        byte descCode = reader.readNextByte();
        AlertLevel level = AlertLevel.getLevelByCode(levelCode);
        AlertDescription description = AlertDescription.getDescriptionByCode(descCode);
        if (level == null) {
            throw new HandshakeException(String.format("Unknown alert level code [%d]", levelCode), new AlertMessage(AlertLevel.FATAL, AlertDescription.DECODE_ERROR, peerAddress));
        }
        if (description == null) {
            throw new HandshakeException(String.format("Unknown alert description code [%d]", descCode), new AlertMessage(AlertLevel.FATAL, AlertDescription.DECODE_ERROR, peerAddress));
        }
        return new AlertMessage(level, description, peerAddress);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public AlertLevel getLevel() {
        return this.level;
    }

    public AlertDescription getDescription() {
        return this.description;
    }

    public boolean isFatal() {
        return AlertLevel.FATAL.equals((Object)this.level);
    }

    public static enum AlertDescription {
        CLOSE_NOTIFY(0, "close_notify"),
        UNEXPECTED_MESSAGE(10, "unexpected_message"),
        BAD_RECORD_MAC(20, "bad_record_mac"),
        DECRYPTION_FAILED_RESERVED(21, "decryption_failed"),
        RECORD_OVERFLOW(22, "record_overflow"),
        DECOMPRESSION_FAILURE(30, "decompression_failure"),
        HANDSHAKE_FAILURE(40, "handshake_failure"),
        NO_CERTIFICATE_RESERVED(41, "no_certificate"),
        BAD_CERTIFICATE(42, "bad_certificate"),
        UNSUPPORTED_CERTIFICATE(43, "unsupported_certificate"),
        CERTIFICATE_REVOKED(44, "certificate_revoked"),
        CERTIFICATE_EXPIRED(45, "certificate_expired"),
        CERTIFICATE_UNKNOWN(46, "certificate_unknown"),
        ILLEGAL_PARAMETER(47, "illegal_parameter"),
        UNKNOWN_CA(48, "unknown_ca"),
        ACCESS_DENIED(49, "access_denied"),
        DECODE_ERROR(50, "decode_error"),
        DECRYPT_ERROR(51, "decrypt_error"),
        EXPORT_RESTRICTION_RESERVED(60, "export_restriction"),
        PROTOCOL_VERSION(70, "protocol_version"),
        INSUFFICIENT_SECURITY(71, "insufficient_security"),
        INTERNAL_ERROR(80, "internal_error"),
        USER_CANCELED(90, "user_canceled"),
        NO_RENEGOTIATION(100, "no_negotiation"),
        UNSUPPORTED_EXTENSION(110, "unsupported_extension"),
        UNKNOWN_PSK_IDENTITY(115, "unknown_psk_identity");

        private byte code;
        private String description;

        private AlertDescription(int code, String description) {
            this.code = (byte)code;
            this.description = description;
        }

        public byte getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static AlertDescription getDescriptionByCode(int code) {
            for (AlertDescription desc : AlertDescription.values()) {
                if (desc.code != (byte)code) continue;
                return desc;
            }
            return null;
        }
    }

    public static enum AlertLevel {
        WARNING(1),
        FATAL(2);

        private byte code;

        private AlertLevel(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }

        public static AlertLevel getLevelByCode(int code) {
            switch (code) {
                case 1: {
                    return WARNING;
                }
                case 2: {
                    return FATAL;
                }
            }
            return null;
        }
    }
}

