/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPCountableBitStream;
import com.igormaznitsa.jbbp.utils.JBBPSystemProperty;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JBBPBitInputStream
extends FilterInputStream
implements JBBPCountableBitStream {
    protected static final int INITIAL_ARRAY_BUFFER_SIZE = JBBPSystemProperty.PROPERTY_INPUT_INITIAL_ARRAY_BUFFER_SIZE.getAsInteger(32);
    private final boolean msb0;
    private int bitBuffer;
    private int bitsInBuffer = 0;
    private long byteCounter;
    private int markedBitBuffer;
    private int markedBitsInBuffer;
    private long markedByteCounter;

    public JBBPBitInputStream(InputStream in) {
        this(in, JBBPBitOrder.LSB0);
    }

    public JBBPBitInputStream(InputStream in, JBBPBitOrder order) {
        super(in);
        this.msb0 = order == JBBPBitOrder.MSB0;
    }

    public boolean[] readBoolArray(int items) throws IOException {
        byte[] buffer;
        int pos = 0;
        if (items < 0) {
            int read;
            buffer = new byte[INITIAL_ARRAY_BUFFER_SIZE];
            while ((read = this.read(buffer, pos, buffer.length - pos)) >= 0) {
                if (buffer.length != (pos += read)) continue;
                byte[] newbuffer = new byte[buffer.length << 1];
                System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                buffer = newbuffer;
            }
        } else {
            int read;
            buffer = new byte[items];
            for (int len = items; len > 0; len -= read) {
                read = this.read(buffer, pos, len);
                if (read < 0) {
                    throw new EOFException("Have read only " + pos + " bit portions instead of " + items);
                }
                pos += read;
            }
        }
        boolean[] result = new boolean[pos];
        for (int i = 0; i < pos; ++i) {
            result[i] = buffer[i] != 0;
        }
        return result;
    }

    private byte[] _readArray(int items, JBBPBitNumber bitNumber) throws IOException {
        boolean readByteArray = bitNumber == null;
        int pos = 0;
        if (items < 0) {
            byte[] buffer = new byte[INITIAL_ARRAY_BUFFER_SIZE];
            while (true) {
                int next;
                int n = next = readByteArray ? this.read() : this.readBits(bitNumber);
                if (next < 0) break;
                if (buffer.length == pos) {
                    byte[] newbuffer = new byte[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = (byte)next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            byte[] result = new byte[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        byte[] buffer = new byte[items];
        if (readByteArray) {
            int read = this.read(buffer, 0, items);
            if (read != items) {
                throw new EOFException("Have read only " + read + " byte(s) instead of " + items + " byte(s)");
            }
        } else {
            for (int i = 0; i < items; ++i) {
                int next = this.readBits(bitNumber);
                if (next < 0) {
                    throw new EOFException("Have read only " + i + " bit portions instead of " + items);
                }
                buffer[i] = (byte)next;
            }
        }
        return buffer;
    }

    public byte[] readBitsArray(int items, JBBPBitNumber bitNumber) throws IOException {
        return this._readArray(items, bitNumber);
    }

    public byte[] readByteArray(int items) throws IOException {
        return this._readArray(items, null);
    }

    public byte[] readByteArray(int items, JBBPByteOrder byteOrder) throws IOException {
        byte[] result = this._readArray(items, null);
        if (byteOrder == JBBPByteOrder.LITTLE_ENDIAN) {
            JBBPUtils.reverseArray(result);
        }
        return result;
    }

    public short[] readShortArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            short[] buffer = new short[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                int next = this.readUnsignedShort(byteOrder);
                if (buffer.length == pos) {
                    short[] newbuffer = new short[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = (short)next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            short[] result = new short[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        short[] buffer = new short[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = (short)this.readUnsignedShort(byteOrder);
        }
        return buffer;
    }

    public char[] readUShortArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            char[] buffer = new char[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                int next = this.readUnsignedShort(byteOrder);
                if (buffer.length == pos) {
                    char[] newbuffer = new char[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = (char)next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            char[] result = new char[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        char[] buffer = new char[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = (char)this.readUnsignedShort(byteOrder);
        }
        return buffer;
    }

    public int[] readIntArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            int[] buffer = new int[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                int next = this.readInt(byteOrder);
                if (buffer.length == pos) {
                    int[] newbuffer = new int[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            int[] result = new int[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        int[] buffer = new int[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readInt(byteOrder);
        }
        return buffer;
    }

    public float[] readFloatArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            float[] buffer = new float[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                float next = this.readFloat(byteOrder);
                if (buffer.length == pos) {
                    float[] newbuffer = new float[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            float[] result = new float[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        float[] buffer = new float[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readFloat(byteOrder);
        }
        return buffer;
    }

    public long[] readLongArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            long[] buffer = new long[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                long next = this.readLong(byteOrder);
                if (buffer.length == pos) {
                    long[] newbuffer = new long[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            long[] result = new long[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        long[] buffer = new long[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readLong(byteOrder);
        }
        return buffer;
    }

    public double[] readDoubleArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            double[] buffer = new double[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                long next = this.readLong(byteOrder);
                if (buffer.length == pos) {
                    double[] newbuffer = new double[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = Double.longBitsToDouble(next);
            }
            if (buffer.length == pos) {
                return buffer;
            }
            double[] result = new double[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        double[] buffer = new double[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readDouble(byteOrder);
        }
        return buffer;
    }

    public int readUnsignedShort(JBBPByteOrder byteOrder) throws IOException {
        int b0 = this.read();
        if (b0 < 0) {
            throw new EOFException();
        }
        int b1 = this.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        return byteOrder == JBBPByteOrder.BIG_ENDIAN ? b0 << 8 | b1 : b1 << 8 | b0;
    }

    public int readInt(JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            return this.readUnsignedShort(byteOrder) << 16 | this.readUnsignedShort(byteOrder);
        }
        return this.readUnsignedShort(byteOrder) | this.readUnsignedShort(byteOrder) << 16;
    }

    public float readFloat(JBBPByteOrder byteOrder) throws IOException {
        int value = byteOrder == JBBPByteOrder.BIG_ENDIAN ? this.readUnsignedShort(byteOrder) << 16 | this.readUnsignedShort(byteOrder) : this.readUnsignedShort(byteOrder) | this.readUnsignedShort(byteOrder) << 16;
        return Float.intBitsToFloat(value);
    }

    public long readLong(JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            return ((long)this.readInt(byteOrder) & 0xFFFFFFFFL) << 32 | (long)this.readInt(byteOrder) & 0xFFFFFFFFL;
        }
        return (long)this.readInt(byteOrder) & 0xFFFFFFFFL | ((long)this.readInt(byteOrder) & 0xFFFFFFFFL) << 32;
    }

    public double readDouble(JBBPByteOrder byteOrder) throws IOException {
        long value = byteOrder == JBBPByteOrder.BIG_ENDIAN ? ((long)this.readInt(byteOrder) & 0xFFFFFFFFL) << 32 | (long)this.readInt(byteOrder) & 0xFFFFFFFFL : (long)this.readInt(byteOrder) & 0xFFFFFFFFL | ((long)this.readInt(byteOrder) & 0xFFFFFFFFL) << 32;
        return Double.longBitsToDouble(value);
    }

    @Override
    public long getCounter() {
        return this.byteCounter;
    }

    @Override
    public int getBitBuffer() {
        return this.bitBuffer;
    }

    @Override
    public int getBufferedBitsNumber() {
        return this.bitsInBuffer;
    }

    @Override
    public JBBPBitOrder getBitOrder() {
        return this.msb0 ? JBBPBitOrder.MSB0 : JBBPBitOrder.LSB0;
    }

    public byte readBitField(JBBPBitNumber numOfBitsToRead) throws IOException {
        int value = this.readBits(numOfBitsToRead);
        if (value < 0) {
            throw new EOFException("Can't read bits from stream [" + (Object)((Object)numOfBitsToRead) + ']');
        }
        return (byte)value;
    }

    public int readBits(JBBPBitNumber numOfBitsToRead) throws IOException {
        int i;
        boolean doIncCounter;
        int numOfBitsAsNumber = numOfBitsToRead.getBitNumber();
        if (this.bitsInBuffer == 0 && numOfBitsAsNumber == 8) {
            int result = this.readByteFromStream();
            if (result >= 0) {
                ++this.byteCounter;
            }
            return result;
        }
        int result = 0;
        if (numOfBitsAsNumber == this.bitsInBuffer) {
            result = this.bitBuffer;
            this.bitBuffer = 0;
            this.bitsInBuffer = 0;
            ++this.byteCounter;
            return result;
        }
        int theBitBuffer = this.bitBuffer;
        int theBitBufferCounter = this.bitsInBuffer;
        boolean bl = doIncCounter = theBitBufferCounter != 0;
        for (i = numOfBitsAsNumber; i > 0; --i) {
            if (theBitBufferCounter == 0) {
                int nextByte;
                if (doIncCounter) {
                    ++this.byteCounter;
                }
                if ((nextByte = this.readByteFromStream()) < 0) {
                    if (i != numOfBitsAsNumber) break;
                    return nextByte;
                }
                theBitBuffer = nextByte;
                theBitBufferCounter = 8;
            }
            result = result << 1 | theBitBuffer & 1;
            theBitBuffer >>= 1;
            --theBitBufferCounter;
        }
        this.bitBuffer = theBitBuffer;
        this.bitsInBuffer = theBitBufferCounter;
        return JBBPUtils.reverseBitsInByte(JBBPBitNumber.decode(numOfBitsAsNumber - i), (byte)result) & 0xFF;
    }

    public boolean readBoolean() throws IOException {
        int read = this.read();
        if (read < 0) {
            throw new EOFException("Can't read a boolean value");
        }
        return read != 0;
    }

    public int readByte() throws IOException {
        int read = this.read();
        if (read < 0) {
            throw new EOFException("Can't read a byte value");
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.bitBuffer = this.markedBitBuffer;
        this.byteCounter = this.markedByteCounter;
        this.bitsInBuffer = this.markedBitsInBuffer;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markedBitBuffer = this.bitBuffer;
        this.markedByteCounter = this.byteCounter;
        this.markedBitsInBuffer = this.bitsInBuffer;
    }

    public void align(long alignByteNumber) throws IOException {
        this.alignByte();
        if (alignByteNumber > 0L) {
            for (long padding = (alignByteNumber - this.byteCounter % alignByteNumber) % alignByteNumber; padding > 0L; --padding) {
                int skippedByte = this.read();
                if (skippedByte >= 0) continue;
                throw new EOFException("Can't align for " + alignByteNumber + " byte(s)");
            }
        }
    }

    @Override
    public long skip(long numOfBytes) throws IOException {
        int nxt;
        if (this.bitsInBuffer == 0) {
            long r = this.in.skip(numOfBytes);
            this.byteCounter += (long)((int)r);
            return r;
        }
        long count = 0L;
        for (long i = numOfBytes; i > 0L && (nxt = this.readBits(JBBPBitNumber.BITS_8)) >= 0; --i) {
            ++count;
        }
        return count;
    }

    private int readByteFromStream() throws IOException {
        int result = this.in.read();
        if (result >= 0 && this.msb0) {
            result = JBBPUtils.reverseBitsInByte((byte)result) & 0xFF;
        }
        return result;
    }

    private int loadNextByteInBuffer() throws IOException {
        int value = this.readByteFromStream();
        if (value < 0) {
            return value;
        }
        this.bitBuffer = value;
        this.bitsInBuffer = 8;
        return value;
    }

    public void alignByte() {
        if (this.bitsInBuffer > 0 && this.bitsInBuffer < 8) {
            ++this.byteCounter;
            this.bitsInBuffer = 0;
        }
    }

    public boolean hasAvailableData() throws IOException {
        return this.bitsInBuffer > 0 || this.loadNextByteInBuffer() >= 0;
    }

    @Override
    public int read(byte[] array, int offset, int length) throws IOException {
        int nextByte;
        int count;
        if (this.bitsInBuffer == 0) {
            int readBytes = 0;
            int tmpoffset = offset;
            int tmplen = length;
            while (tmplen > 0) {
                int read = this.in.read(array, tmpoffset, tmplen);
                if (read < 0) {
                    readBytes = readBytes == 0 ? read : readBytes;
                    break;
                }
                tmplen -= read;
                tmpoffset += read;
                readBytes += read;
                this.byteCounter += (long)read;
            }
            if (this.msb0) {
                int index = offset;
                for (int number = readBytes; number > 0; --number) {
                    array[index] = JBBPUtils.reverseBitsInByte(array[index]);
                    ++index;
                }
            }
            return readBytes;
        }
        int i = offset;
        for (count = length; count > 0 && (nextByte = this.readBits(JBBPBitNumber.BITS_8)) >= 0; --count) {
            array[i++] = (byte)nextByte;
        }
        return length - count;
    }

    @Override
    public void resetCounter() {
        if (this.bitsInBuffer < 8) {
            this.bitsInBuffer = 0;
            this.bitBuffer = 0;
        }
        this.byteCounter = 0L;
    }

    @Override
    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    @Override
    public int read() throws IOException {
        if (this.bitsInBuffer == 0) {
            int result = this.readByteFromStream();
            if (result >= 0) {
                ++this.byteCounter;
            }
            return result;
        }
        return this.readBits(JBBPBitNumber.BITS_8);
    }

    private IOException makeIOExceptionForWrongPrefix(int prefix) {
        return new IOException("Wrong string prefix:" + prefix);
    }

    public String readString(JBBPByteOrder byteOrder) throws IOException {
        int len;
        block7: {
            int prefix;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            prefix = this.readByte();
                            if (prefix != 0) break block6;
                            len = 0;
                            break block7;
                        }
                        if (prefix != 255) break block8;
                        len = -1;
                        break block7;
                    }
                    if (prefix >= 128) break block9;
                    len = prefix;
                    break block7;
                }
                if ((prefix & 0xF0) != 128) break block10;
                switch (prefix & 0xF) {
                    case 1: {
                        len = this.readByte();
                        break block7;
                    }
                    case 2: {
                        len = this.readUnsignedShort(byteOrder);
                        break block7;
                    }
                    case 3: {
                        int buffer = byteOrder == JBBPByteOrder.BIG_ENDIAN ? this.readByte() << 16 | this.readByte() << 8 | this.readByte() : this.readByte() | this.readByte() << 8 | this.readByte() << 16;
                        len = buffer;
                        break block7;
                    }
                    case 4: {
                        len = this.readInt(byteOrder);
                        break block7;
                    }
                    default: {
                        throw this.makeIOExceptionForWrongPrefix(prefix);
                    }
                }
            }
            throw this.makeIOExceptionForWrongPrefix(prefix);
        }
        String result = len < 0 ? null : (len == 0 ? "" : JBBPUtils.utf8ToStr(this.readByteArray(len)));
        return result;
    }

    public String[] readStringArray(int items, JBBPByteOrder byteOrder) throws IOException {
        int pos = 0;
        if (items < 0) {
            String[] buffer = new String[INITIAL_ARRAY_BUFFER_SIZE];
            while (this.hasAvailableData()) {
                String next = this.readString(byteOrder);
                if (buffer.length == pos) {
                    String[] newbuffer = new String[buffer.length << 1];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    buffer = newbuffer;
                }
                buffer[pos++] = next;
            }
            if (buffer.length == pos) {
                return buffer;
            }
            String[] result = new String[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
            return result;
        }
        String[] buffer = new String[items];
        for (int i = 0; i < items; ++i) {
            buffer[i] = this.readString(byteOrder);
        }
        return buffer;
    }
}

