/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.i18n;

import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.LocationProvider;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.internal.i18n.LanguageResourceBundleManager;
import org.openhab.core.internal.i18n.ResourceBundleTracker;
import org.openhab.core.library.dimension.ArealDensity;
import org.openhab.core.library.dimension.Currency;
import org.openhab.core.library.dimension.DataAmount;
import org.openhab.core.library.dimension.DataTransferRate;
import org.openhab.core.library.dimension.Density;
import org.openhab.core.library.dimension.ElectricConductivity;
import org.openhab.core.library.dimension.EmissionIntensity;
import org.openhab.core.library.dimension.EnergyPrice;
import org.openhab.core.library.dimension.Intensity;
import org.openhab.core.library.dimension.RadiantExposure;
import org.openhab.core.library.dimension.RadiationSpecificActivity;
import org.openhab.core.library.dimension.VolumePrice;
import org.openhab.core.library.dimension.VolumetricFlowRate;
import org.openhab.core.library.types.PointType;
import org.openhab.core.library.unit.CurrencyUnits;
import org.openhab.core.library.unit.ImperialUnits;
import org.openhab.core.library.unit.MetricPrefix;
import org.openhab.core.library.unit.SIUnits;
import org.openhab.core.library.unit.Units;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.openhab.i18n"}, property={"service.pid=org.openhab.i18n", "service.config.label=Regional Settings", "service.config.category=system", "service.config.description.uri=system:i18n"})
@NonNullByDefault
public class I18nProviderImpl
implements TranslationProvider,
LocaleProvider,
LocationProvider,
TimeZoneProvider,
UnitProvider {
    private final Logger logger = LoggerFactory.getLogger(I18nProviderImpl.class);
    public static final String CONFIGURATION_PID = "org.openhab.i18n";
    public static final String LANGUAGE = "language";
    public static final String SCRIPT = "script";
    public static final String REGION = "region";
    public static final String VARIANT = "variant";
    private @Nullable Locale locale;
    private final ResourceBundleTracker resourceBundleTracker;
    static final String LOCATION = "location";
    private @Nullable PointType location;
    static final String TIMEZONE = "timezone";
    private @Nullable ZoneId timeZone;
    static final String MEASUREMENT_SYSTEM = "measurementSystem";
    private @Nullable SystemOfUnits measurementSystem;
    private static final Map<Class<? extends Quantity<?>>, Map<SystemOfUnits, Unit<? extends Quantity<?>>>> DIMENSION_MAP = I18nProviderImpl.getDimensionMap();

    @Activate
    public I18nProviderImpl(ComponentContext componentContext) {
        I18nProviderImpl.getDimensionMap();
        this.modified((Map)((Object)componentContext.getProperties()));
        this.resourceBundleTracker = new ResourceBundleTracker(componentContext.getBundleContext(), this);
        this.resourceBundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.resourceBundleTracker.close();
    }

    @Modified
    protected synchronized void modified(Map<String, Object> config) {
        String language = this.toStringOrNull(config.get(LANGUAGE));
        String script = this.toStringOrNull(config.get(SCRIPT));
        String region = this.toStringOrNull(config.get(REGION));
        String variant = this.toStringOrNull(config.get(VARIANT));
        String location = this.toStringOrNull(config.get(LOCATION));
        String zoneId = this.toStringOrNull(config.get(TIMEZONE));
        String measurementSystem = this.toStringOrNull(config.get(MEASUREMENT_SYSTEM));
        this.setTimeZone(zoneId);
        this.setLocation(location);
        this.setLocale(language, script, region, variant);
        this.setMeasurementSystem(measurementSystem);
    }

    private void setMeasurementSystem(@Nullable String measurementSystem) {
        SystemOfUnits oldMeasurementSystem = this.measurementSystem;
        String ms = measurementSystem == null || measurementSystem.isEmpty() ? "" : measurementSystem;
        SystemOfUnits newMeasurementSystem = switch (ms) {
            case "SI" -> SIUnits.getInstance();
            case "US" -> ImperialUnits.getInstance();
            default -> {
                this.logger.debug("Error setting measurement system for value '{}'.", (Object)measurementSystem);
                yield null;
            }
        };
        this.measurementSystem = newMeasurementSystem;
        if (oldMeasurementSystem != null && newMeasurementSystem == null) {
            this.logger.info("Measurement system is not set, falling back to locale based system.");
        } else if (newMeasurementSystem != null && !newMeasurementSystem.equals(oldMeasurementSystem)) {
            this.logger.info("Measurement system set to '{}'.", (Object)newMeasurementSystem.getName());
        }
    }

    private void setLocale(@Nullable String language, @Nullable String script, @Nullable String region, @Nullable String variant) {
        Locale newLocale;
        Locale oldLocale = this.locale;
        if (language == null || language.isEmpty()) {
            this.logger.debug("No language set, setting locale to 'null'.");
            this.locale = null;
            if (oldLocale != null) {
                this.logger.info("Locale is not set, falling back to the default locale");
            }
            return;
        }
        Locale.Builder builder = new Locale.Builder();
        try {
            builder.setLanguage(language);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Language ({}) is invalid. Cannot create locale, keep old one.", (Object)language, (Object)ex);
            return;
        }
        try {
            builder.setScript(script);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Script ({}) is invalid. Skip it.", (Object)script, (Object)ex);
            return;
        }
        try {
            builder.setRegion(region);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Region ({}) is invalid. Skip it.", (Object)region, (Object)ex);
            return;
        }
        try {
            builder.setVariant(variant);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Variant ({}) is invalid. Skip it.", (Object)variant, (Object)ex);
            return;
        }
        this.locale = newLocale = builder.build();
        if (!newLocale.equals(oldLocale)) {
            this.logger.info("Locale set to '{}'.", (Object)newLocale);
        }
    }

    private @Nullable String toStringOrNull(@Nullable Object value) {
        return value == null ? null : value.toString();
    }

    private void setLocation(@Nullable String location) {
        PointType newLocation;
        PointType oldLocation = this.location;
        if (location == null || location.isEmpty()) {
            newLocation = null;
        } else {
            try {
                newLocation = PointType.valueOf(location);
            }
            catch (IllegalArgumentException e) {
                newLocation = oldLocation;
                this.logger.warn("Could not set new location: {}, keeping old one, error message: {}", (Object)location, (Object)e.getMessage());
            }
        }
        if (!Objects.equals(newLocation, oldLocation)) {
            this.location = newLocation;
            this.logger.info("Location set to '{}'.", (Object)newLocation);
        }
    }

    private void setTimeZone(@Nullable String zoneId) {
        ZoneId oldTimeZone = this.timeZone;
        if (zoneId == null || zoneId.isBlank()) {
            this.timeZone = null;
        } else {
            try {
                this.timeZone = ZoneId.of(zoneId);
            }
            catch (DateTimeException e) {
                this.logger.warn("Error setting time zone '{}', falling back to the default time zone: {}", (Object)zoneId, (Object)e.getMessage());
                this.timeZone = null;
            }
        }
        if (oldTimeZone != null && this.timeZone == null) {
            this.logger.info("Time zone is not set, falling back to the default time zone.");
        } else {
            ZoneId zId;
            ZoneId zoneId2 = this.timeZone;
            if (zoneId2 instanceof ZoneId && !(zId = zoneId2).equals(oldTimeZone)) {
                this.logger.info("Time zone set to '{}'.", (Object)this.timeZone);
            }
        }
    }

    @Override
    public @Nullable PointType getLocation() {
        return this.location;
    }

    @Override
    public ZoneId getTimeZone() {
        ZoneId timeZone = this.timeZone;
        if (timeZone == null) {
            return ZoneId.systemDefault();
        }
        return timeZone;
    }

    @Override
    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    @Override
    public @Nullable String getText(@Nullable Bundle bundle, @Nullable String key, @Nullable String defaultText, @Nullable Locale locale) {
        String text;
        LanguageResourceBundleManager languageResource = this.resourceBundleTracker.getLanguageResource(bundle);
        if (languageResource != null && (text = languageResource.getText(key, locale)) != null) {
            return text;
        }
        return defaultText;
    }

    @Override
    public @Nullable String getText(@Nullable Bundle bundle, @Nullable String key, @Nullable String defaultText, @Nullable Locale locale, Object ... arguments) {
        String text = this.getText(bundle, key, defaultText, locale);
        try {
            if (text != null) {
                return MessageFormat.format(text, arguments);
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Failed to format message '{}' with parameters {}. This is a bug.", (Object)text, (Object)arguments);
        }
        return text;
    }

    @Override
    public <T extends Quantity<T>> Unit<T> getUnit(Class<T> dimension) {
        Map<SystemOfUnits, Unit<Quantity<?>>> map = DIMENSION_MAP.get(dimension);
        if (map == null) {
            throw new IllegalArgumentException("Dimension " + dimension.getName() + " is unknown. This is a bug.");
        }
        Unit<? extends Quantity<?>> unit = map.get(this.getMeasurementSystem());
        return Objects.requireNonNull(unit);
    }

    @Override
    public SystemOfUnits getMeasurementSystem() {
        SystemOfUnits measurementSystem = this.measurementSystem;
        if (measurementSystem != null) {
            return measurementSystem;
        }
        if (Locale.US.equals(this.locale) || Locale.forLanguageTag("en-LR").equals(this.locale)) {
            return ImperialUnits.getInstance();
        }
        return SIUnits.getInstance();
    }

    @Override
    public Collection<Class<? extends Quantity<?>>> getAllDimensions() {
        return Set.copyOf(I18nProviderImpl.getDimensionMap().keySet());
    }

    public static Map<Class<? extends Quantity<?>>, Map<SystemOfUnits, Unit<? extends Quantity<?>>>> getDimensionMap() {
        HashMap dimensionMap = new HashMap();
        I18nProviderImpl.addDefaultUnit(dimensionMap, Acceleration.class, Units.METRE_PER_SQUARE_SECOND);
        I18nProviderImpl.addDefaultUnit(dimensionMap, AmountOfSubstance.class, Units.MOLE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Angle.class, Units.DEGREE_ANGLE, Units.DEGREE_ANGLE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Area.class, SIUnits.SQUARE_METRE, ImperialUnits.SQUARE_FOOT);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ArealDensity.class, Units.DOBSON_UNIT);
        I18nProviderImpl.addDefaultUnit(dimensionMap, CatalyticActivity.class, Units.KATAL);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Currency.class, CurrencyUnits.BASE_CURRENCY);
        I18nProviderImpl.addDefaultUnit(dimensionMap, DataAmount.class, Units.BYTE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, DataTransferRate.class, Units.MEGABIT_PER_SECOND);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Density.class, Units.KILOGRAM_PER_CUBICMETRE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Dimensionless.class, Units.ONE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricCapacitance.class, Units.FARAD);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricCharge.class, Units.COULOMB);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricConductance.class, Units.SIEMENS);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricConductivity.class, Units.SIEMENS_PER_METRE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricCurrent.class, Units.AMPERE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricInductance.class, Units.HENRY);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricPotential.class, Units.VOLT);
        I18nProviderImpl.addDefaultUnit(dimensionMap, ElectricResistance.class, Units.OHM);
        I18nProviderImpl.addDefaultUnit(dimensionMap, EmissionIntensity.class, Units.GRAM_PER_KILOWATT_HOUR);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Energy.class, Units.KILOWATT_HOUR);
        I18nProviderImpl.addDefaultUnit(dimensionMap, EnergyPrice.class, CurrencyUnits.BASE_ENERGY_PRICE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Force.class, Units.NEWTON);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Frequency.class, Units.HERTZ);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Illuminance.class, Units.LUX);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Intensity.class, Units.IRRADIANCE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Length.class, SIUnits.METRE, ImperialUnits.INCH);
        I18nProviderImpl.addDefaultUnit(dimensionMap, LuminousFlux.class, Units.LUMEN);
        I18nProviderImpl.addDefaultUnit(dimensionMap, LuminousIntensity.class, Units.CANDELA);
        I18nProviderImpl.addDefaultUnit(dimensionMap, MagneticFlux.class, Units.WEBER);
        I18nProviderImpl.addDefaultUnit(dimensionMap, MagneticFluxDensity.class, Units.TESLA);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Mass.class, SIUnits.KILOGRAM, ImperialUnits.POUND);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Power.class, Units.WATT);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Pressure.class, MetricPrefix.HECTO(SIUnits.PASCAL), ImperialUnits.INCH_OF_MERCURY);
        I18nProviderImpl.addDefaultUnit(dimensionMap, RadiationDoseAbsorbed.class, Units.GRAY);
        I18nProviderImpl.addDefaultUnit(dimensionMap, RadiationDoseEffective.class, Units.SIEVERT);
        I18nProviderImpl.addDefaultUnit(dimensionMap, RadiationSpecificActivity.class, Units.BECQUEREL_PER_CUBIC_METRE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, RadiantExposure.class, Units.JOULE_PER_SQUARE_METRE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Radioactivity.class, Units.BECQUEREL);
        I18nProviderImpl.addDefaultUnit(dimensionMap, SolidAngle.class, Units.STERADIAN);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Speed.class, SIUnits.KILOMETRE_PER_HOUR, ImperialUnits.MILES_PER_HOUR);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Temperature.class, SIUnits.CELSIUS, ImperialUnits.FAHRENHEIT);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Time.class, Units.SECOND);
        I18nProviderImpl.addDefaultUnit(dimensionMap, Volume.class, SIUnits.CUBIC_METRE, ImperialUnits.GALLON_LIQUID_US);
        I18nProviderImpl.addDefaultUnit(dimensionMap, VolumePrice.class, CurrencyUnits.PRICE_PER_LITRE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, VolumePrice.class, CurrencyUnits.PRICE_PER_CUBIC_METRE);
        I18nProviderImpl.addDefaultUnit(dimensionMap, VolumePrice.class, CurrencyUnits.PRICE_PER_GALLON_LIQUID_US);
        I18nProviderImpl.addDefaultUnit(dimensionMap, VolumetricFlowRate.class, Units.LITRE_PER_MINUTE, ImperialUnits.GALLON_PER_MINUTE);
        return dimensionMap;
    }

    private static <T extends Quantity<T>> void addDefaultUnit(Map<Class<? extends Quantity<?>>, Map<SystemOfUnits, Unit<? extends Quantity<?>>>> dimensionMap, Class<T> dimension, Unit<T> siUnit, Unit<T> imperialUnit) {
        dimensionMap.put(dimension, Map.of(SIUnits.getInstance(), siUnit, ImperialUnits.getInstance(), imperialUnit));
    }

    private static <T extends Quantity<T>> void addDefaultUnit(Map<Class<? extends Quantity<?>>, Map<SystemOfUnits, Unit<? extends Quantity<?>>>> dimensionMap, Class<T> dimension, Unit<T> unit) {
        dimensionMap.put(dimension, Map.of(SIUnits.getInstance(), unit, ImperialUnits.getInstance(), unit));
    }
}

