/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResource;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelCoreConstants;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.core.SafeEMF;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class ModelRepositoryImpl
implements ModelRepository {
    private final Logger logger = LoggerFactory.getLogger(ModelRepositoryImpl.class);
    private final ResourceSet resourceSet;
    private final Map<String, String> resourceOptions = Map.of(XtextResource.OPTION_ENCODING, StandardCharsets.UTF_8.name());
    private final List<ModelRepositoryChangeListener> listeners = new CopyOnWriteArrayList<ModelRepositoryChangeListener>();
    private final SafeEMF safeEmf;
    private int counter;

    @Activate
    public ModelRepositoryImpl(@Reference SafeEMF safeEmf) {
        this.safeEmf = safeEmf;
        SynchronizedXtextResourceSet xtextResourceSet = new SynchronizedXtextResourceSet();
        xtextResourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        this.resourceSet = xtextResourceSet;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable EObject getModel(String name) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            block5: {
                Resource resource = this.getResource(name);
                if (resource == null) break block5;
                if (!resource.getContents().isEmpty()) {
                    return (EObject)resource.getContents().getFirst();
                }
                this.logger.warn("DSL model '{}' is either empty or cannot be parsed correctly!", (Object)name);
                this.resourceSet.getResources().remove((Object)resource);
                return null;
            }
            this.logger.trace("DSL model '{}' can not be found", (Object)name);
            return null;
        }
    }

    @Override
    public boolean addOrRefreshModel(String name, InputStream originalInputStream) {
        if (ModelCoreConstants.isIsolatedModel(name)) {
            this.logger.info("Ignoring DSL model '{}'", (Object)name);
            return false;
        }
        return this.addOrRefreshModel(name, originalInputStream, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean addOrRefreshModel(String name, InputStream originalInputStream, @Nullable List<String> errors, @Nullable List<String> warnings) {
        block40: {
            byte[] bytes;
            InputStream inputStream;
            Object var8_11;
            this.logger.info("Loading DSL model '{}'", (Object)name);
            Resource resource = null;
            try {
                Throwable throwable = null;
                var8_11 = null;
                try {
                    inputStream = originalInputStream;
                    try {
                        bytes = inputStream.readAllBytes();
                        ArrayList<String> newErrors = new ArrayList<String>();
                        ArrayList<String> newWarnings = new ArrayList<String>();
                        boolean valid = this.validateModel(name, new ByteArrayInputStream(bytes), newErrors, newWarnings);
                        if (errors != null) {
                            errors.addAll(newErrors);
                        }
                        if (warnings != null) {
                            warnings.addAll(newWarnings);
                        }
                        if (!valid) {
                            this.logger.warn("DSL model '{}' has errors, therefore ignoring it: {}", (Object)name, (Object)String.join((CharSequence)"\n", newErrors));
                            this.removeModel(name);
                            return false;
                        }
                        if (!newWarnings.isEmpty()) {
                            this.logger.info("Validation issues found in DSL model '{}', using it anyway:\n{}", (Object)name, (Object)String.join((CharSequence)"\n", newWarnings));
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (errors != null) {
                    errors.add("Model cannot be parsed correctly: %s".formatted(e.getMessage()));
                }
                this.logger.warn("DSL model '{}' cannot be parsed correctly!", (Object)name, (Object)e);
                return false;
            }
            try {
                Throwable e = null;
                var8_11 = null;
                try {
                    inputStream = new ByteArrayInputStream(bytes);
                    try {
                        ResourceSet resourceSet;
                        block41: {
                            resource = this.getResource(name);
                            if (resource != null) break block41;
                            resourceSet = this.resourceSet;
                            synchronized (resourceSet) {
                                block39: {
                                    resource = this.getResource(name);
                                    if (resource != null) break block40;
                                    Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("*");
                                    resource = this.resourceSet.createResource(URI.createURI((String)name));
                                    if (resource == null) break block39;
                                    resource.load(inputStream, this.resourceOptions);
                                    this.notifyListeners(name, EventType.ADDED);
                                    return true;
                                }
                                this.logger.warn("Ignoring file '{}' as we do not have a parser for it.", (Object)name);
                                break block40;
                            }
                        }
                        resourceSet = this.resourceSet;
                        synchronized (resourceSet) {
                            resource.unload();
                            resource.load(inputStream, this.resourceOptions);
                            this.notifyListeners(name, EventType.MODIFIED);
                            return true;
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                if (errors != null) {
                    errors.add("Model cannot be parsed correctly: %s".formatted(e.getMessage()));
                }
                this.logger.warn("DSL model '{}' cannot be parsed correctly!", (Object)name, (Object)e);
                if (resource == null) break block40;
                this.resourceSet.getResources().remove((Object)resource);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeModel(String name) {
        this.logger.info("Unloading DSL model '{}'", (Object)name);
        Resource resource = this.getResource(name);
        if (resource != null) {
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                this.notifyListeners(name, EventType.REMOVED);
                this.resourceSet.getResources().remove((Object)resource);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getAllModelNamesOfType(String modelType) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            return resourceListCopy.stream().filter(input -> input.getURI().lastSegment().contains(".") && input.isLoaded() && modelType.equalsIgnoreCase(input.getURI().fileExtension()) && !ModelCoreConstants.isIsolatedModel(input.getURI().lastSegment())).map(from -> from.getURI().path()).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadAllModelsOfType(String modelType) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            for (Resource resource : resourceListCopy) {
                if (!resource.getURI().lastSegment().contains(".") || !resource.isLoaded() || !modelType.equalsIgnoreCase(resource.getURI().fileExtension()) || ModelCoreConstants.isIsolatedModel(resource.getURI().lastSegment())) continue;
                XtextResource xtextResource = (XtextResource)resource;
                this.logger.debug("Refreshing resource '{}'", (Object)resource.getURI().lastSegment());
                xtextResource.update(1, 0, "");
                this.notifyListeners(resource.getURI().lastSegment(), EventType.MODIFIED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> removeAllModelsOfType(String modelType) {
        HashSet<String> ret = new HashSet<String>();
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            for (Resource resource : resourceListCopy) {
                if (!resource.getURI().lastSegment().contains(".") || !resource.isLoaded() || !modelType.equalsIgnoreCase(resource.getURI().fileExtension()) || ModelCoreConstants.isIsolatedModel(resource.getURI().lastSegment())) continue;
                this.logger.debug("Removing resource '{}'", (Object)resource.getURI().lastSegment());
                ret.add(resource.getURI().lastSegment());
                this.resourceSet.getResources().remove((Object)resource);
                this.notifyListeners(resource.getURI().lastSegment(), EventType.REMOVED);
            }
        }
        return ret;
    }

    @Override
    public void addModelRepositoryChangeListener(ModelRepositoryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelRepositoryChangeListener(ModelRepositoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public @Nullable String createIsolatedModel(String modelType, InputStream inputStream, List<String> errors, List<String> warnings) {
        String name;
        return this.addOrRefreshModel(name = "%smodel_%d.%s".formatted("___tmp_", ++this.counter, modelType), inputStream, errors, warnings) ? name : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateFileFormat(OutputStream out, String modelType, EObject modelContent) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            block8: {
                String name = "%sgenerated_%d.%s".formatted("___tmp_", ++this.counter, modelType);
                Resource resource = this.resourceSet.createResource(URI.createURI((String)name));
                try {
                    try {
                        resource.getContents().add((Object)modelContent);
                        resource.save(out, Map.of(XtextResource.OPTION_ENCODING, StandardCharsets.UTF_8.name()));
                    }
                    catch (IOException e) {
                        this.logger.warn("Exception when saving DSL model {}", (Object)resource.getURI().lastSegment());
                        this.resourceSet.getResources().remove((Object)resource);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.resourceSet.getResources().remove((Object)resource);
                    throw throwable;
                }
                this.resourceSet.getResources().remove((Object)resource);
            }
        }
    }

    private @Nullable Resource getResource(String name) {
        return this.resourceSet.getResource(URI.createURI((String)name), false);
    }

    private boolean validateModel(String name, InputStream inputStream, List<String> errors, List<String> warnings) throws IOException {
        Resource resource = this.resourceSet.createResource(URI.createURI((String)("___tmp_" + name)));
        try {
            resource.load(inputStream, this.resourceOptions);
            if (!resource.getContents().isEmpty()) {
                Resource.Diagnostic diagnostic2;
                for (Resource.Diagnostic diagnostic2 : resource.getErrors()) {
                    errors.add(MessageFormat.format("[{0},{1}]: {2}", Integer.toString(diagnostic2.getLine()), Integer.toString(diagnostic2.getColumn()), diagnostic2.getMessage()));
                }
                if (!resource.getErrors().isEmpty()) {
                    return false;
                }
                diagnostic2 = this.safeEmf.call(() -> Diagnostician.INSTANCE.validate((EObject)resource.getContents().getFirst()));
                for (Diagnostic d : diagnostic2.getChildren()) {
                    if (d.getSeverity() == 4) {
                        errors.add(d.getMessage());
                        continue;
                    }
                    warnings.add(d.getMessage());
                }
                if (!errors.isEmpty()) {
                    return false;
                }
            }
        }
        finally {
            this.resourceSet.getResources().remove((Object)resource);
        }
        return true;
    }

    private void notifyListeners(String name, EventType type) {
        for (ModelRepositoryChangeListener listener : this.listeners) {
            listener.modelChanged(name, type);
        }
    }
}

