/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.sacommons.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ThreatIntelTriggerDto
implements Writeable,
ToXContentObject {
    public static final String DATA_SOURCES_FIELD = "data_sources";
    public static final String IOC_TYPES_FIELD = "ioc_types";
    public static final String ACTIONS_FIELD = "actions";
    public static final String ID_FIELD = "id";
    public static final String NAME_FIELD = "name";
    public static final String SEVERITY_FIELD = "severity";
    private final List<String> dataSources;
    private final List<String> iocTypes;
    private final List<Action> actions;
    private final String name;
    private final String id;
    private final String severity;

    public ThreatIntelTriggerDto(List<String> dataSources, List<String> iocTypes, List<Action> actions, String name, String id, String severity) {
        this.dataSources = dataSources == null ? Collections.emptyList() : dataSources;
        this.iocTypes = iocTypes == null ? Collections.emptyList() : iocTypes;
        this.actions = actions;
        this.name = name;
        this.id = StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString() : id;
        this.severity = severity;
    }

    public ThreatIntelTriggerDto(StreamInput sin) throws IOException {
        this(sin.readStringList(), sin.readStringList(), sin.readList(Action::new), sin.readString(), sin.readString(), sin.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.dataSources);
        out.writeStringCollection(this.iocTypes);
        out.writeList(this.actions);
        out.writeString(this.name);
        out.writeString(this.id);
        out.writeString(this.severity);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(DATA_SOURCES_FIELD, this.dataSources).field(IOC_TYPES_FIELD, this.iocTypes).field(ACTIONS_FIELD, this.actions).field(ID_FIELD, this.id).field(NAME_FIELD, this.name).field(SEVERITY_FIELD, this.severity).endObject();
    }

    public static ThreatIntelTriggerDto readFrom(StreamInput sin) throws IOException {
        return new ThreatIntelTriggerDto(sin);
    }

    public static ThreatIntelTriggerDto parse(XContentParser xcp) throws IOException {
        ArrayList<String> iocTypes = new ArrayList<String>();
        ArrayList<String> dataSources = new ArrayList<String>();
        ArrayList<Action> actions = new ArrayList<Action>();
        String name = "";
        String id = null;
        String severity = "";
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "ioc_types": {
                    ArrayList<String> vals = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        vals.add(xcp.text());
                    }
                    iocTypes.addAll(vals);
                    continue block16;
                }
                case "data_sources": {
                    ArrayList<String> ds = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        ds.add(xcp.text());
                    }
                    dataSources.addAll(ds);
                    continue block16;
                }
                case "actions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        actions.add(Action.parse((XContentParser)xcp));
                    }
                    continue block16;
                }
                case "id": {
                    id = xcp.text();
                    continue block16;
                }
                case "name": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block16;
                    name = xcp.text();
                    continue block16;
                }
                case "severity": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block16;
                    severity = xcp.text();
                    continue block16;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelTriggerDto(dataSources, iocTypes, actions, name, id, severity);
    }

    public List<String> getDataSources() {
        return this.dataSources;
    }

    public List<String> getIocTypes() {
        return this.iocTypes;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getSeverity() {
        return this.severity;
    }
}

