/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.searchrelevance.utils.ParserUtils;

public class JudgmentCache
implements ToXContentObject {
    public static final String ID = "id";
    public static final String QUERY_TEXT = "queryText";
    public static final String DOCUMENT_ID = "documentId";
    public static final String CONTEXT_FIELDS_STR = "contextFieldsStr";
    public static final String TIME_STAMP = "timestamp";
    public static final String RATING = "rating";
    public static final String MODEL_ID = "modelId";
    private String id;
    private String timestamp;
    private String queryText;
    private String documentId;
    private String contextFieldsStr;
    private String rating;
    private String modelId;

    public JudgmentCache(String id, String timestamp, String queryText, String documentId, List<String> contextFields, String rating, String modelId) {
        this.id = id;
        this.timestamp = timestamp;
        this.queryText = queryText;
        this.documentId = documentId;
        this.contextFieldsStr = ParserUtils.convertListToSortedStr(contextFields);
        this.rating = rating;
        this.modelId = modelId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(ID, this.id.trim());
        xContentBuilder.field(TIME_STAMP, this.timestamp.trim());
        xContentBuilder.field(QUERY_TEXT, this.queryText.trim());
        xContentBuilder.field(DOCUMENT_ID, this.documentId.trim());
        xContentBuilder.field(CONTEXT_FIELDS_STR, this.contextFieldsStr);
        xContentBuilder.field(RATING, this.rating.trim());
        xContentBuilder.field(MODEL_ID, this.modelId.trim());
        return xContentBuilder.endObject();
    }

    public String id() {
        return this.id;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public String queryText() {
        return this.queryText;
    }

    public String documentId() {
        return this.documentId;
    }

    public String contextFieldsStr() {
        return this.contextFieldsStr;
    }

    public String score() {
        return this.rating;
    }
}

