/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;

public final class Rate {
    private double m_amount;
    private TimeUnit m_units;

    public Rate(Number number, TimeUnit timeUnit) {
        this.m_amount = number == null ? 0.0 : number.doubleValue();
        this.m_units = timeUnit;
    }

    public Rate(double d, TimeUnit timeUnit) {
        this.m_amount = d;
        this.m_units = timeUnit;
    }

    public double getAmount() {
        return this.m_amount;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Rate) {
            Rate rate = (Rate)object;
            bl = this.amountComponentEquals(rate) && this.m_units == rate.m_units;
        }
        return bl;
    }

    public boolean amountComponentEquals(Rate rate) {
        return NumberHelper.equals(this.m_amount, rate.m_amount, 1.0E-5);
    }

    public int hashCode() {
        return (int)this.m_amount + this.m_units.hashCode();
    }

    public String toString() {
        return this.m_amount + this.m_units.toString();
    }
}

